/*
 *  spkm3/spkm3_mech.h
 *
 *  Copyright (c) 2001,2004 The Regents of the University of Michigan.
 *  All rights reserved.
 *
 *  Andy Adamson <andros@umich.edu>
 *
 *  Redistribution and use in source and binary forms, with or without
 *  modification, are permitted provided that the following conditions
 *  are met:
 *
 *  1. Redistributions of source code must retain the above copyright
 *     notice, this list of conditions and the following disclaimer.
 *  2. Redistributions in binary form must reproduce the above copyright
 *     notice, this list of conditions and the following disclaimer in the
 *     documentation and/or other materials provided with the distribution.
 *  3. Neither the name of the University nor the names of its
 *     contributors may be used to endorse or promote products derived
 *     from this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESS OR IMPLIED
 *  WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 *  DISCLAIMED. IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 *  FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 *  CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 *  SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
 *  BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 *  LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 *  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 *  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

OM_uint32 spkm3_gss_accept_sec_context(
    OM_uint32 * minor_status,
    gss_ctx_id_t * context_handle,
    gss_cred_id_t verifier_cred_handle,
    gss_buffer_t input_token,
    gss_channel_bindings_t input_chan_bindings,
    gss_name_t * src_name,
    gss_OID * mech_type,
    gss_buffer_t output_token,
    OM_uint32 * ret_flags,
    OM_uint32 * time_rec,
    gss_cred_id_t * delegated_cred_handle);

OM_uint32 spkm3_gss_acquire_cred(
    OM_uint32 * minor_status,
    gss_name_t desired_name,
    OM_uint32 time_req,
    gss_OID_set desired_mechs,
    gss_cred_usage_t cred_usage,
    gss_cred_id_t * output_cred_handle,
    gss_OID_set * actual_mechs,
    OM_uint32 * time_rec);

OM_uint32 spkm3_gss_add_cred(
    OM_uint32 * minor_status,
    gss_cred_id_t input_cred_handle,
    gss_name_t desired_name,
    gss_OID desired_mech,
    gss_cred_usage_t cred_usage,
    OM_uint32 initiator_time_req,
    OM_uint32 acceptor_time_req,
    gss_cred_id_t * output_cred_handle,
    gss_OID_set * actual_mechs,
    OM_uint32 * initiator_time_rec,
    OM_uint32 * acceptor_time_rec);

OM_uint32 spkm3_gss_compare_name(
    OM_uint32 * minor_status,
    gss_name_t name1,
    gss_name_t name2,
    int *name_equal);

OM_uint32 spkm3_gss_context_time(
    OM_uint32 * minor_status,
    gss_ctx_id_t context_handle,
    OM_uint32 * time_rec);


OM_uint32 spkm3_gss_delete_sec_context(
    OM_uint32 * minor_status,
    gss_ctx_id_t * context_handle,
    gss_buffer_t output_token);

OM_uint32 spkm3_gss_display_name(
    OM_uint32 * minor_status,
    gss_name_t input_name,
    gss_buffer_t output_name_buffer,
    gss_OID * output_name_type);

OM_uint32 spkm3_gss_display_status(
    OM_uint32 * minor_status,
    OM_uint32 status_value,
    int status_type,
    gss_OID mech_type,
    OM_uint32 * message_context,
    gss_buffer_t status_string);

OM_uint32 spkm3_gss_export_sec_context(
    OM_uint32 * minor_status,
    gss_ctx_id_t * context_handle,
    gss_buffer_t interprocess_token);

OM_uint32 spkm3_gss_import_name(
    OM_uint32 * minor_status,
    gss_buffer_t input_name_buffer,
    gss_OID input_name_type,
    gss_name_t * output_name);

OM_uint32 spkm3_gss_import_sec_context(
    OM_uint32 * minor_status,
    gss_buffer_t interprocess_token,
    gss_ctx_id_t * context_handle);

OM_uint32 spkm3_gss_indicate_mechs(
    OM_uint32 * minor_status,
    gss_OID_set * mech_set);

OM_uint32 spkm3_gss_init_sec_context(
    OM_uint32 * minor_status,
    gss_cred_id_t claimant_cred_handle,
    gss_ctx_id_t * context_handle,
    gss_name_t target_name,
    gss_OID mech_type,
    OM_uint32 req_flags,
    OM_uint32 time_req,
    gss_channel_bindings_t input_chan_bindings,
    gss_buffer_t input_token,
    gss_OID * actual_mech_type,
    gss_buffer_t output_token,
    OM_uint32 * ret_flags,
    OM_uint32 * time_rec);

OM_uint32 spkm3_gss_inquire_context(
    OM_uint32 * minor_status,
    gss_ctx_id_t context_handle,
    gss_name_t * initiator_name,
    gss_name_t * acceptor_name,
    OM_uint32 * lifetime_rec,
    gss_OID * mech_type,
    OM_uint32 * ret_flags,
    int *locally_initiated,
    int *open);

OM_uint32 spkm3_gss_inquire_cred(
    OM_uint32 * minor_status,
    gss_cred_id_t cred_handle,
    gss_name_t * name,
    OM_uint32 * lifetime_ret,
    gss_cred_usage_t * cred_usage,
    gss_OID_set * mechanisms);

OM_uint32 spkm3_gss_inquire_cred_by_mech(
    OM_uint32 * minor_status,
    gss_cred_id_t cred_handle,
    gss_OID mech_type,
    gss_name_t * name,
    OM_uint32 * initiator_lifetime,
    OM_uint32 * acceptor_lifetime,
    gss_cred_usage_t * cred_usage);

OM_uint32 spkm3_gss_inquire_names_for_mech(
    OM_uint32 * minor_status,
    gss_OID mechanism,
    gss_OID_set * name_types);

OM_uint32 spkm3_gss_oid_to_str(
    OM_uint32 * minor_status,
    gss_OID oid,
    gss_buffer_t oid_str);

OM_uint32 spkm3_gss_process_context_token(
    OM_uint32 * minor_status,
    gss_ctx_id_t context_handle,
    gss_buffer_t token_buffer);

OM_uint32 spkm3_gss_release_name(
    OM_uint32 * minor_status,
    gss_name_t * input_name);

/* ANDROS added this function */
OM_uint32 spkm3_gss_internal_release_oid(
    OM_uint32 * minor_status,
    gss_OID * oid);

OM_uint32 spkm3_gss_release_oid(
    OM_uint32 * minor_status,
    gss_OID * oid);

OM_uint32 spkm3_gss_seal(
    OM_uint32 * minor_status,
    gss_ctx_id_t context_handle,
    int conf_req_flag,
    int qop_req,
    gss_buffer_t input_message_buffer,
    int *conf_state,
    gss_buffer_t output_message_buffer);

OM_uint32 spkm3_gss_get_mic(
    OM_uint32 * minor_status,
    gss_ctx_id_t context_handle,
    gss_qop_t qop_req,
    gss_buffer_t message_buffer,
    gss_buffer_t message_token);

OM_uint32 spkm3_gss_verify_mic(
    OM_uint32 * minor_status,
    gss_ctx_id_t context_handle,
    gss_buffer_t message_buffer,
    gss_buffer_t token_buffer,
    int * qop_state);

OM_uint32 spkm3_gss_wrap(
    OM_uint32 * minor_status,
    gss_ctx_id_t context_handle,
    int conf_req_flag,
    gss_qop_t qop_req,
    gss_buffer_t input_message_buffer,
    int *conf_state,
    gss_buffer_t output_message_buffer);

OM_uint32 spkm3_gss_str_to_oid(
    OM_uint32 * minor_status,
    gss_buffer_t oid_str,
    gss_OID * oid);

OM_uint32 spkm3_gss_test_oid_set_member(
    OM_uint32 * minor_status,
    gss_OID member,
    gss_OID_set set,
    int *present);

OM_uint32 spkm3_gss_unseal(
    OM_uint32 * minor_status,
    gss_ctx_id_t context_handle,
    gss_buffer_t input_message_buffer,
    gss_buffer_t output_message_buffer,
    int *conf_state,
    int *qop_state);

OM_uint32 spkm3_gss_unwrap(
    OM_uint32 * minor_status,
    gss_ctx_id_t context_handle,
    gss_buffer_t input_message_buffer,
    gss_buffer_t output_message_buffer,
    int *conf_state,
    gss_qop_t * qop_state);

OM_uint32 spkm3_gss_verify(
    OM_uint32 * minor_status,
    gss_ctx_id_t context_handle,
    gss_buffer_t message_buffer,
    gss_buffer_t token_buffer,
    int *qop_state);

OM_uint32 spkm3_gss_wrap_size_limit(
    OM_uint32 * minor_status,
    gss_ctx_id_t context_handle,
    int conf_req_flag,
    gss_qop_t qop_req,
    OM_uint32 req_output_size,
    OM_uint32 * max_input_size);

OM_uint32 spkm3_gss_release_cred(
    OM_uint32 * minor_status,
    gss_cred_id_t * cred_handle);

OM_uint32 spkm3_pname_to_uid(
    char *,			/* principal name */
    gss_OID,			/* name_type */
    gss_OID,			/* mech_type */
    uid_t *			/* uid (OUT) */
    );

int spkm3_gss_pname_to_uid (
    char *,             /* pname */
    gss_OID,            /* name type */
    gss_OID,            /* mech type */
    uid_t *             /* uid */
);
             

OM_uint32 spkm3_gss_duplicate_name(
    OM_uint32 *,		/* minor_status */
    const gss_name_t,		/* input_name */
    gss_name_t *		/* dest_name */
    );


OM_uint32 spkm3_gss_set_allowable_enctypes(
    OM_uint32 *,		/* min_status */
    gss_cred_id_t,		/* cred_handle */
    OM_uint32,			/* num_ktypes */
    void *			/* ktypes */
    );

OM_uint32
spkm3_gss_export_lucid_sec_context (
    OM_uint32 *, 		/* min_status */
    gss_ctx_id_t *,		/* context_handle */
    OM_uint32,			/* interface version */
    void **			/* internal lucid context */
    );

OM_uint32
spkm3_gss_free_lucid_sec_context (
    OM_uint32 *, 		/* min_status */
    gss_ctx_id_t *,		/* context_handle */
    void **			/* internal lucid context */
    );
