/*
 * spkm3_mech.c 
 *
 *  Copyright (c) 2001,2004 The Regents of the University of Michigan.
 *  All rights reserved.
 *
 *  Andy Adamson <andros@umich.edu>
 *
 *  Redistribution and use in source and binary forms, with or without
 *  modification, are permitted provided that the following conditions
 *  are met:
 *
 *  1. Redistributions of source code must retain the above copyright
 *     notice, this list of conditions and the following disclaimer.
 *  2. Redistributions in binary form must reproduce the above copyright
 *     notice, this list of conditions and the following disclaimer in the
 *     documentation and/or other materials provided with the distribution.
 *  3. Neither the name of the University nor the names of its
 *     contributors may be used to endorse or promote products derived
 *
 *     from this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESS OR IMPLIED
 *  WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 *  DISCLAIMED. IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 *  FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 *  CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 *  SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
 *  BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 *  LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 *  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 *  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
*/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif
#include "mglueP.h"		/* from krb5 lib/gssapi/mechglue */
#include <stdio.h>
#include "spkm3_mech.h"
#include "gssapi_spkm3.h"

static struct gss_config spkm3_mechanism =
	{ {7, "\053\006\001\005\005\001\003"},
	(void *) NULL,
	spkm3_gss_acquire_cred,
	spkm3_gss_release_cred,
	spkm3_gss_init_sec_context,
	spkm3_gss_accept_sec_context,
	spkm3_gss_process_context_token,
	spkm3_gss_delete_sec_context,
	spkm3_gss_context_time,
	spkm3_gss_get_mic,
	spkm3_gss_verify_mic,
	spkm3_gss_wrap,
	spkm3_gss_unwrap,
	spkm3_gss_display_status,
	spkm3_gss_indicate_mechs,
	spkm3_gss_compare_name,
	spkm3_gss_display_name,
	spkm3_gss_import_name,
	spkm3_gss_release_name,
	spkm3_gss_inquire_cred,
	spkm3_gss_add_cred,
	spkm3_gss_export_sec_context,
	spkm3_gss_import_sec_context,
	spkm3_gss_inquire_cred_by_mech,
	spkm3_gss_inquire_names_for_mech,
	spkm3_gss_inquire_context,
	spkm3_gss_internal_release_oid,
	spkm3_gss_wrap_size_limit,
	spkm3_pname_to_uid,
	spkm3_gss_duplicate_name,
	spkm3_gss_set_allowable_enctypes,
	spkm3_gss_verify_mic,
	spkm3_gss_export_lucid_sec_context,
	spkm3_gss_free_lucid_sec_context,
};

/* spkm3 code doesn't use the gss_mechanism context */
gss_mechanism
spkm3_gss_initialize ()
{
	return (&spkm3_mechanism);
}


/* Function Stubs */
#if 0
OM_uint32
spkm3_gss_delete_sec_context (
	OM_uint32 * min_status,	/* minor_status */
	gss_ctx_id_t * ctx_hndl,	/* context_handle */
	gss_buffer_t token_out	/* output_token */
   )
{
	SPKM3_DEBUG (1, ("STUB: spkm3_gss_delete_sec_context called\n"));

	*ctx_hndl = NULL;
	*min_status = 0;
	return GSS_S_FAILURE;
}
#endif

OM_uint32
spkm3_gss_inquire_cred (
	OM_uint32 * min_status,	/* minor_status */
	gss_cred_id_t crd_hdnl,	/* cred_handle */
	gss_name_t * name,	/* name */
	OM_uint32 * lifetm,	/* lifetime */
	int *cred_usage,	/* cred_usage */
	gss_OID_set * mech_oid_set	/* mechanisms */
   )
{
	SPKM3_DEBUG (1, ("STUB: spkm3_gss_inquire_cred called\n"));
	*min_status = 0;
	return GSS_S_FAILURE;
}

OM_uint32
spkm3_gss_add_cred (
	OM_uint32 * min_status,	/* minor_status */
	gss_cred_id_t cred_hdnl_in,	/* input_cred_handle */
	gss_name_t name_req,	/* desired_name */
	gss_OID mech_oid,	/* desired_mech */
	gss_cred_usage_t cred_usage,	/* cred_usage */
	OM_uint32 time_req_init,	/* initiator_time_req */
	OM_uint32 time_req_accpt,	/* acceptor_time_req */
	gss_cred_id_t * cred_hdnl_out,	/* output_cred_handle */
	gss_OID_set * mech_oid_set,	/* actual_mechs */
	OM_uint32 * time_rec_init,	/* initiator_time_rec */
	OM_uint32 * time_rec_accpt	/* acceptor_time_rec */
   )
{
	SPKM3_DEBUG (1, ("STUB: spkm3_gss_add_cred called\n"));
	*min_status = 0;
	return GSS_S_FAILURE;
}

OM_uint32
spkm3_gss_export_sec_context (
	OM_uint32 * min_status,	/* minor_status */
	gss_ctx_id_t * ctx_hndl,	/* context_handle */
	gss_buffer_t token_inter	/* interprocess_token */
   )
{
	SPKM3_DEBUG (1, ("STUB: spkm3_gss_export_sec_context called\n"));
	*min_status = 0;
	return GSS_S_FAILURE;
}

OM_uint32
spkm3_gss_import_sec_context (
				     OM_uint32 * min_status,	/* minor_status */
				     gss_buffer_t token_inter,	/* interprocess_token */
				     gss_ctx_id_t * ctx_hndl	/* context_handle */
   )
{
	SPKM3_DEBUG (1, ("STUB: spkm3_gss_import_sec_context called\n"));
	*min_status = 0;
	return GSS_S_FAILURE;
}

OM_uint32
spkm3_gss_inquire_cred_by_mech (
	OM_uint32 * min_status,	/* minor_status */
	gss_cred_id_t cred_handle,	/* cred_handle */
	gss_OID mech_oid,	/* mech_type */
	gss_name_t * name,	/* name */
	OM_uint32 * lifetm_init,	/* initiator_lifetime */
	OM_uint32 * lifetm_accpt,	/* acceptor_lifetime */
	gss_cred_usage_t * cred_usage	/* cred_usage */
   )
{
	SPKM3_DEBUG (1, ("STUB: spkm3_gss_inquire_cred_by_mech called\n"));
	*min_status = 0;
	return GSS_S_FAILURE;
}

OM_uint32
spkm3_gss_inquire_context (
	OM_uint32 * min_status,	/* minor_status */
	gss_ctx_id_t ctx_hndl,	/* context_handle */
	gss_name_t * name_src,	/* src_name */
	gss_name_t * name_targ,	/* targ_name */
	OM_uint32 * lifetine_rec,	/* lifetime_rec */
	gss_OID * mech_oid,	/* mech_type */
	OM_uint32 * flags_ctx,	/* ctx_flags */
	int *local_init,	/* locally_initiated */
	int *open	/* open */
   )
{
	SPKM3_DEBUG (1, ("STUB: spkm3_gss_inquire_context called\n"));
	*min_status = 0;
	return GSS_S_FAILURE;
}

OM_uint32
spkm3_gss_wrap_size_limit (
	OM_uint32 * min_status,	/* minor_status */
	gss_ctx_id_t ctx_hndl,	/* context_handle */
	int flog_req,	/* conf_req_flag */
	gss_qop_t qop_req,	/* qop_req */
	OM_uint32 size_req_out,	/* req_output_size */
	OM_uint32 * size_max_in	/* max_input_size */
   )
{
	SPKM3_DEBUG (1, ("STUB: spkm3_gss_wrap_size_limit called\n"));
	*min_status = 0;
	return GSS_S_FAILURE;
}

OM_uint32
spkm3_pname_to_uid (
	char *pname,	/* pname */
	gss_OID name_oid,	/* name type */
	gss_OID mech_oid,	/* mech type */
	uid_t * uid	/* uid */
   )
{
	SPKM3_DEBUG (1, ("STUB: spkm3_pname_to_uid called\n"));
	return GSS_S_FAILURE;
}


/* V2 interface */
OM_uint32
spkm3_gss_canonicalize_name (OM_uint32 * min_status,
			     const gss_name_t input_name,
			     const gss_OID mech_type,
			     gss_name_t * output_name)
{
	SPKM3_DEBUG (1, ("STUB: spkm3_canonicalize_name called\n"));
	*min_status = 0;
	return GSS_S_FAILURE;
}

/* V2 interface */
OM_uint32
spkm3_gss_export_name (OM_uint32 * min_status,
		       const gss_name_t input_name,
		       gss_buffer_t exported_name)
{
	SPKM3_DEBUG (1, ("STUB: spkm3_export_name called\n"));
	*min_status = 0;
	return GSS_S_FAILURE;
}

/* Mechanism-specific routine */
OM_uint32
spkm3_gss_set_allowable_enctypes (OM_uint32 * min_status,
				  gss_cred_id_t cred_handle,
				  OM_uint32 num_ktypes, void *ktypes)
{
	SPKM3_DEBUG (1, ("STUB: spkm3_gss_set_allowable_enctypes called\n"));
	*min_status = 0;
	return GSS_S_FAILURE;
}
