/*
 *  spkm3/spkm3_lucid.h
 *
 *  Copyright (c) 2005 The Regents of the University of Michigan.
 *  All rights reserved.
 *
 *  Andy Adamson <andros@umich.edu>
 *
 *  Redistribution and use in source and binary forms, with or without
 *  modification, are permitted provided that the following conditions
 *  are met:
 *
 *  1. Redistributions of source code must retain the above copyright
 *     notice, this list of conditions and the following disclaimer.
 *  2. Redistributions in binary form must reproduce the above copyright
 *     notice, this list of conditions and the following disclaimer in the
 *     documentation and/or other materials provided with the distribution.
 *  3. Neither the name of the University nor the names of its
 *     contributors may be used to endorse or promote products derived
 *     from this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESS OR IMPLIED
 *  WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 *  DISCLAIMED. IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 *  FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 *  CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 *  SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
 *  BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 *  LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 *  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 *  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */
/* first pass at spkm3 lucid context */

#include <gssapi/gssapi.h>

typedef struct gss_spkm3_lucid_ctx_t {
	int version;                    /* version = 1 */
	gss_buffer_desc ctx_id;
	int qop;
	gss_buffer_desc mech_used;
	OM_uint32 ret_flags;
	OM_uint32 req_flags;
	gss_buffer_desc share_key;
	gss_buffer_desc derived_conf_key;
	gss_buffer_desc derived_integ_key;
	/* OID's of the negotiated algorithms */
	gss_buffer_desc keyestb_alg;
	gss_buffer_desc owf_alg;
	gss_buffer_desc intg_alg;
	gss_buffer_desc conf_alg;
} gss_spkm3_lucid_ctx_t;

OM_uint32
gss_spkm3_export_lucid_sec_context (
                          OM_uint32 * min_status,
                          gss_ctx_id_t *context_handle,
                          OM_uint32  version,
                          void ** vcdx);

OM_uint32
gss_spkm3_free_lucid_sec_context(
                        OM_uint32 * min_status,
                        void *lctx);
