/*
 *  spkm3/release_oid.c
 *
 *  Copyright (c) 2004 The Regents of the University of Michigan.
 *  All rights reserved.
 *
 *  Redistribution and use in source and binary forms, with or without
 *  modification, are permitted provided that the following conditions
 *  are met:
 *
 *  1. Redistributions of source code must retain the above copyright
 *     notice, this list of conditions and the following disclaimer.
 *  2. Redistributions in binary form must reproduce the above copyright
 *     notice, this list of conditions and the following disclaimer in the
 *     documentation and/or other materials provided with the distribution.
 *  3. Neither the name of the University nor the names of its
 *     contributors may be used to endorse or promote products derived
 *     from this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESS OR IMPLIED
 *  WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 *  DISCLAIMED. IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 *  FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 *  CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 *  SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
 *  BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 *  LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 *  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 *  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif
#include <stdio.h>
#include <stdlib.h>
#include <sys/time.h>
#include <unistd.h>
#include <string.h>
#include <errno.h>
#include "gssapi_spkm3.h"

OM_uint32 spkm3_gss_internal_release_oid (
						 OM_uint32 * min_status,
						 gss_OID * oid);

/*
 * Function: spkm3_gss_release_oid()
 */
OM_uint32
spkm3_gss_release_oid (
			      OM_uint32 * min_status,	/* minor_status */
			      gss_OID * oid)
{				/* oid */
	OM_uint32 maj_status = GSS_S_COMPLETE;

	SPKM3_DEBUG (1, ("spkm3_gss_release_oid:\n"));

	if (spkm3_gss_internal_release_oid (min_status, oid) !=
	    GSS_S_COMPLETE) {
		return (generic_gss_release_oid (min_status, oid));
	}

      exit:
	if(maj_status != GSS_S_COMPLETE) 
	  spkm3_log_status ("spkm3_gss_release_oid:", maj_status, *min_status);

	return (maj_status);
}

/*
 * Function: spkm3_gss_internal_release_oid()
 */
OM_uint32
spkm3_gss_internal_release_oid (
				       OM_uint32 * min_status,	/* minor_status */
				       gss_OID * oid)
{				/* oid */
	OM_uint32 maj_status = GSS_S_COMPLETE;

	SPKM3_DEBUG (1, ("spkm3_gss_internal_release_oid: %p\n", *oid));

	if (min_status)
		*min_status = 0;

	SPKM3_DEBUG (3, ("spkm3_gss_internal_release_oid:\n"
		 "  gss_mech_oid_spkm3            %p\n"
		 "  gss_mech_oid_ialg_nullmac     %p\n"
		 "  GSS_C_NT_USER_NAME            %p\n"
		 "  GSS_C_NT_MACHINE_UID_NAME     %p\n"
		 "  GSS_C_NT_STRING_UID_NAME      %p\n"
		 "  GSS_C_NT_HOSTBASED_SERVICE    %p\n"
		 "  GSS_C_NT_ANONYMOUS            %p\n"
		 "  GSS_C_NT_EXPORT_NAME          %p\n",
		 gss_mech_oid_spkm3, gss_mech_oid_ialg_nullmac,
		 GSS_C_NT_USER_NAME, GSS_C_NT_MACHINE_UID_NAME,
		 GSS_C_NT_STRING_UID_NAME, GSS_C_NT_HOSTBASED_SERVICE,
		 GSS_C_NT_ANONYMOUS, GSS_C_NT_EXPORT_NAME));

	/* If this is one of our oids, then say it is done */
	if ((*oid != gss_mech_oid_spkm3) &&
	    (*oid != gss_mech_oid_ialg_nullmac) &&
	    (*oid != GSS_C_NT_USER_NAME) &&
	    (*oid != GSS_C_NT_MACHINE_UID_NAME) &&
	    (*oid != GSS_C_NT_STRING_UID_NAME) &&
	    (*oid != GSS_C_NT_HOSTBASED_SERVICE) &&
	    (*oid != GSS_C_NT_ANONYMOUS) && (*oid != GSS_C_NT_EXPORT_NAME)) {
		/* This isn't one of ours ... */
		SPKM3_DEBUG (1, ("spkm3_gss_internal_release_oid: "
                             "NOT one of ours\n"));
		maj_status = GSS_S_CONTINUE_NEEDED;
	}
	else {
		SPKM3_DEBUG (1, ("spkm3_gss_internal_release_oid: "
                             "IS one of ours\n"));
		*oid = GSS_C_NO_OID;
	}

      exit:
	if(maj_status != GSS_S_COMPLETE && maj_status != GSS_S_CONTINUE_NEEDED)
	  spkm3_log_status ("spkm3_gss_internal_release_oid:",
			    maj_status, *min_status);

	return (maj_status);
}
