/*
 *  spkm3/release_name.c
 *
 *  Copyright (c) 2001,2004 The Regents of the University of Michigan.
 *  All rights reserved.
 *
 *  Redistribution and use in source and binary forms, with or without
 *  modification, are permitted provided that the following conditions
 *  are met:
 *
 *  1. Redistributions of source code must retain the above copyright
 *     notice, this list of conditions and the following disclaimer.
 *  2. Redistributions in binary form must reproduce the above copyright
 *     notice, this list of conditions and the following disclaimer in the
 *     documentation and/or other materials provided with the distribution.
 *  3. Neither the name of the University nor the names of its
 *     contributors may be used to endorse or promote products derived
 *     from this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESS OR IMPLIED
 *  WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 *  DISCLAIMED. IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 *  FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 *  CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 *  SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
 *  BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 *  LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 *  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 *  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif
#include <stdio.h>
#include <stdlib.h>
#include <sys/time.h>
#include <unistd.h>
#include <string.h>
#include <errno.h>
#include "gssapi_spkm3.h"

/*
 * Function: spkm3_gss_release_name()
 */
OM_uint32
spkm3_gss_release_name (
			       OM_uint32 * min_status,	/* minor_status */
			       gss_name_t * name)
{				/* input_name */
	spkm3_name_desc_t *cn;
	char *ptr;
	OM_uint32 maj_status = GSS_S_COMPLETE;

	*min_status = 0;

	if (name == NULL || *name == NULL || *name == GSS_C_NO_NAME) {
		goto err;
	}

	cn = (spkm3_name_desc_t *) * name;
	SPKM3_DEBUG(1, ("spkm3_gss_release_name: string_name '%s'\n",
		    cn->string_name ? cn->string_name : "<NULL>"));
#ifdef ASNDEBUG
	asn_fprint (stderr, &asn_DEF_Name, cn->asn1_name);
#endif
	if (cn->string_name)
		free (cn->string_name);
	if (cn->asn1_name)
		asn_DEF_Name.free_struct (&asn_DEF_Name, cn->asn1_name, 0);
	free (cn);
	*name = NULL;

      err:
	return (maj_status);
}
