/*
 * spkm3/acquire_cred.c 
 *
 *  Copyright (c) 2004 The Regents of the University of Michigan.
 *  All rights reserved.
 *
 *  Kevin Coffman <kwc@umich.edu>
 *
 *  Redistribution and use in source and binary forms, with or without
 *  modification, are permitted provided that the following conditions
 *  are met:
 *
 *  1. Redistributions of source code must retain the above copyright
 *     notice, this list of conditions and the following disclaimer.
 *  2. Redistributions in binary form must reproduce the above copyright
 *     notice, this list of conditions and the following disclaimer in the
 *     documentation and/or other materials provided with the distribution.
 *  3. Neither the name of the University nor the names of its
 *     contributors may be used to endorse or promote products derived
 *
 *     from this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESS OR IMPLIED
 *  WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 *  DISCLAIMED. IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 *  FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 *  CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 *  SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
 *  BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 *  LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 *  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 *  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
*/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif
#include <stdio.h>
#include "gssapi_spkm3.h"


OM_uint32
spkm3_gss_release_cred (
			       OM_uint32 * min_status,	/* minor_status */
			       gss_cred_id_t * cred_handle	/* cred_handle */
   )
{
	OM_uint32 maj_status = GSS_S_FAILURE;
	spkm3_cred_int_t *spkm3_cred;

	*min_status = 0;
	if (cred_handle == NULL || *cred_handle == GSS_C_NO_CREDENTIAL) {
		maj_status = GSS_S_COMPLETE;
		goto out;
	}

	/* XXX Verify handle XXX */
	spkm3_cred = (spkm3_cred_int_t *) * cred_handle;
	*cred_handle = GSS_C_NO_CREDENTIAL;

	if (spkm3_cred->cert) {
		X509_free (spkm3_cred->cert);
	}
	if (spkm3_cred->priv_key) {
		EVP_PKEY_free (spkm3_cred->priv_key);
	}

	free (spkm3_cred);

	maj_status = GSS_S_COMPLETE;

      out:
	return maj_status;
}
