/*
 *  spkm3/indicate_mechs.c
 *
 *  Copyright (c) 2004 The Regents of the University of Michigan.
 *  All rights reserved.
 *
 *  Redistribution and use in source and binary forms, with or without
 *  modification, are permitted provided that the following conditions
 *  are met:
 *
 *  1. Redistributions of source code must retain the above copyright
 *     notice, this list of conditions and the following disclaimer.
 *  2. Redistributions in binary form must reproduce the above copyright
 *     notice, this list of conditions and the following disclaimer in the
 *     documentation and/or other materials provided with the distribution.
 *  3. Neither the name of the University nor the names of its
 *     contributors may be used to endorse or promote products derived
 *     from this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESS OR IMPLIED
 *  WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 *  DISCLAIMED. IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 *  FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 *  CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 *  SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
 *  BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 *  LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 *  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 *  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif
#include <stdio.h>
#include <stdlib.h>
#include <sys/time.h>
#include <unistd.h>
#include <string.h>
#include <errno.h>
#include "gssapi_spkm3.h"

/*
 * Function: spkm3_gss_indicate_mechs()
 *
 * Description: returns set of implementation-supported mechanisms
 *
 */
OM_uint32
spkm3_gss_indicate_mechs (
				 OM_uint32 * min_status,	/* minor_status */
				 gss_OID_set * mech_set)
{				/* set of mechanisms returned */
	OM_uint32 maj_status = GSS_S_FAILURE;

	SPKM3_DEBUG (1, ("spkm3_gss_indicate_mechs: START\n"));

	if (min_status)
		*min_status = 0;

	/* Don't do any work if they don't really want the results! */
	if (mech_set == NULL)
		goto exit;

	if (!g_copy_OID_set (&spkm3_oid_set, mech_set)) {
		*mech_set = GSS_C_NO_OID_SET;
		*min_status = ENOMEM;
		goto exit;
	}

	maj_status = GSS_S_COMPLETE;
	goto exit;

      exit:
	if(maj_status != GSS_S_COMPLETE)
	  spkm3_log_status ("spkm3_gss_indicate_mechs:", maj_status,
			    *min_status);

	return (maj_status);
}
