/*
 *  spkm3/dup_name.c
 *
 *  Copyright (c) 2004 The Regents of the University of Michigan.
 *  All rights reserved.
 *
 *  Redistribution and use in source and binary forms, with or without
 *  modification, are permitted provided that the following conditions
 *  are met:
 *
 *  1. Redistributions of source code must retain the above copyright
 *     notice, this list of conditions and the following disclaimer.
 *  2. Redistributions in binary form must reproduce the above copyright
 *     notice, this list of conditions and the following disclaimer in the
 *     documentation and/or other materials provided with the distribution.
 *  3. Neither the name of the University nor the names of its
 *     contributors may be used to endorse or promote products derived
 *     from this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESS OR IMPLIED
 *  WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 *  DISCLAIMED. IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 *  FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 *  CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 *  SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
 *  BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 *  LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 *  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 *  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif
#include <stdio.h>
#include <stdlib.h>
#include <sys/time.h>
#include <unistd.h>
#include <string.h>
#include <errno.h>
#include "gssapi_spkm3.h"

/*
 * Function: spkm3_gss_duplicate_name()
 *
 * Description: returns a copy of the given name.
 */
OM_uint32
spkm3_gss_duplicate_name (
			  OM_uint32 * min_status,	/* minor_status */
			  gss_buffer_t name_in,		/* input_name_buffer */
			  gss_name_t * exp_name)	/* output copy of name */
{			
	spkm3_name_desc_t *out, *in;
	char *ptr;
	OM_uint32 maj_status = GSS_S_COMPLETE;

	*min_status = 0;

	SPKM3_DEBUG (1, ("spkm3_gss_import_name: START\n"));

	/* XXX Verify name handle */
	in = (spkm3_name_desc_t *) name_in;

	/* Don't waste any time here if nowhere to put the output */
	if (exp_name == NULL)
		goto exit;
	else
		*exp_name = NULL;

	out = (spkm3_name_desc_t *) malloc (sizeof (spkm3_name_desc_t));
	if (out == NULL) {
		*min_status = ENOMEM;
		maj_status = GSS_S_FAILURE;
		goto exit;
	}
	memset (out, 0, sizeof (spkm3_name_desc_t));


	out->oid = in->oid;
	out->type = in->type;
	out->length = in->length;
	out->string_name = strdup (in->string_name);
	if ((out->asn1_name = asn1_name_dup (in->asn1_name)) == NULL) {
		free (out);
		*min_status = ENOMEM;
		maj_status = GSS_S_FAILURE;
		goto exit;
	}

	*exp_name = out;

exit:
	if(maj_status != GSS_S_COMPLETE)
	  spkm3_log_status ("spkm3_gss_duplicate_name:", maj_status,
			    *min_status);

	return (maj_status);
}
