/*
 *  spkm3/display_status.c
 *
 *  Copyright (c) 2001,2004 The Regents of the University of Michigan.
 *  All rights reserved.
 *
 *  Redistribution and use in source and binary forms, with or without
 *  modification, are permitted provided that the following conditions
 *  are met:
 *
 *  1. Redistributions of source code must retain the above copyright
 *     notice, this list of conditions and the following disclaimer.
 *  2. Redistributions in binary form must reproduce the above copyright
 *     notice, this list of conditions and the following disclaimer in the
 *     documentation and/or other materials provided with the distribution.
 *  3. Neither the name of the University nor the names of its
 *     contributors may be used to endorse or promote products derived
 *     from this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESS OR IMPLIED
 *  WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 *  DISCLAIMED. IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 *  FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 *  CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 *  SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
 *  BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 *  LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 *  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 *  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif
#include <stdio.h>
#include <string.h>
#include "gssapi_spkm3.h"

OM_uint32
spkm3_gss_display_status (
				 OM_uint32 * min_status,	/* minor_status */
				 OM_uint32 status_val,	/* status_value */
				 int status_type,	/* status_type */
				 gss_OID mech_req,	/* mech_type */
				 OM_uint32 * msg_ctx,	/* message_context */
				 gss_buffer_t status_str	/* status_string */
   )
{
	OM_uint32 maj_status = GSS_S_COMPLETE;
	unsigned char *message = NULL;
	int message_allocated = 0;
	*min_status = 0;

	status_str->length = 0;
	status_str->value = NULL;

	if (status_type == GSS_C_GSS_CODE) {
		switch (GSS_ERROR (status_val)) {
		case 0:
			message = "No error";
			break;
		case GSS_S_FAILURE:
			message = "Miscellaneous failure";
			break;
		case GSS_S_DEFECTIVE_TOKEN:
			message = "Defective token (communication error?)";
			break;
		case GSS_S_DEFECTIVE_CREDENTIAL:
			message =
			   "Defective credential (authenticaion error)";
			break;
		case GSS_S_CREDENTIALS_EXPIRED:
			message = "Credentials expired";
			break;
		case GSS_S_BAD_NAME:
			message = "Service or hostname not supported";
			break;
		case GSS_S_UNAUTHORIZED:
			message = "Not authorized";
			break;
		case GSS_S_NO_CRED:
			message = "No valid credentials";
			break;
		case GSS_S_BAD_SIG:
			message = "Invalid message signature";
			break;
		default:
			message = "Unclassified GSS error";
			break;
		}
	}
	else if (status_type == GSS_C_MECH_CODE) {
		switch (status_val) {
		case 0:
			message = "No error";
			break;
		default:
			message = (unsigned char *) malloc (50);
			if (message == NULL) {
				maj_status = ENOMEM;
				goto err_exit;
			}
			message_allocated = 1;
			snprintf (message, 50,
				  "Mechanism error code 0x%08x", status_val);
			break;
		}
	}
	else {
		maj_status = GSS_S_BAD_STATUS;
		goto err_exit;
	}

	if (message) {
		if (message_allocated) {
			status_str->value = message;
		}
		else {
			status_str->value =
			   (char *) malloc (strlen (message) + 1);
			if (status_str->value == NULL) {
				maj_status = ENOMEM;
				goto err_exit;
			}
			strcpy (status_str->value, message);
		}
		status_str->length = strlen (status_str->value);
	}

      err_exit:
	return maj_status;
}
