/*
 *  spkm3/disp_name.c
 *
 *  Copyright (c) 2004 The Regents of the University of Michigan.
 *  All rights reserved.
 *
 *  Andy Adamson <andros@umich.edu>
 *
 *  Redistribution and use in source and binary forms, with or without
 *  modification, are permitted provided that the following conditions
 *  are met:
 *
 *  1. Redistributions of source code must retain the above copyright
 *     notice, this list of conditions and the following disclaimer.
 *  2. Redistributions in binary form must reproduce the above copyright
 *     notice, this list of conditions and the following disclaimer in the
 *     documentation and/or other materials provided with the distribution.
 *  3. Neither the name of the University nor the names of its
 *     contributors may be used to endorse or promote products derived
 *     from this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESS OR IMPLIED
 *  WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 *  DISCLAIMED. IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 *  FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 *  CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 *  SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
 *  BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 *  LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 *  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 *  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif
#include <stdio.h>
#include <stdlib.h>
#include <sys/time.h>
#include <unistd.h>
#include <string.h>
#include <errno.h>
#include "gssapi_spkm3.h"

/*
 * Function: spkm3_gss_display_name()
 *
 * Description: creates the cn name "service/host"
 * NOTE: uses hard coded UMICH preamble.
 */
OM_uint32
spkm3_gss_display_name (
			       OM_uint32 * min_status,	/* minor_status */
			       gss_name_t name_in,	/* input_name */
			       gss_buffer_t name_out,	/* output_name_buffer */
			       gss_OID * name_out_type	/* output_name_type */
   )
{
	OM_uint32 maj_stat = GSS_S_FAILURE;
	spkm3_name_desc_t *name = (spkm3_name_desc_t *) name_in;

	*min_status = 0;
	name_out->length = 0;
	name_out->value = NULL;

	if ((name->type == SPKM3_NT_ANONYMOUS_NAME) ||
	    				(name->type == SPKM3_NT_USER_NAME)) {
		name_out->length = name->length;
		name_out->value = (char *) malloc (name->length + 1);
		if (!name_out->value) {
			*min_status = ENOMEM;
			goto out;
		}
		memcpy ((char *) name_out->value, name->string_name,
			name->length);
		((char *) name_out->value)[name_out->length] = 0;
	
		SPKM3_DEBUG (1, ("spkm3_gss_display_name: %s\n",
			     name->string_name));
	
		if (name_out_type) {
			if (name->type == SPKM3_NT_ANONYMOUS_NAME) 
				*name_out_type = GSS_C_NT_ANONYMOUS; 
			else if (name->type == SPKM3_NT_USER_NAME)
				*name_out_type = GSS_C_NT_USER_NAME;
		}
		maj_stat = GSS_S_COMPLETE;
	}
      out:
	return maj_stat;
}
