#ifdef HAVE_CONFIG_H
#include "config.h"
#endif
#include "gssapi_spkm3.h"


OM_uint32 spkm3_gss_copy_oid (OM_uint32 * minor_status,
                              gss_OID oid,
                              gss_OID *new_oid) {
       gss_OID p;

        p = (gss_OID) malloc (sizeof (gss_OID_desc));
        if (!p) {
                *minor_status = GSS_S_G_MEMORY_ALLOC;
                return GSS_S_FAILURE;
        }
        p->length = oid->length;
        p->elements = malloc (p->length);
        if (!p->elements) {
                free (p);
                *minor_status = GSS_S_G_MEMORY_ALLOC;
                return GSS_S_FAILURE;
        }
        memcpy (p->elements, oid->elements, p->length);
        *new_oid = p;
        return (GSS_S_COMPLETE);

}

