/*
 * Generated by asn1c-0.9.14 (http://lionet.info/asn1c)
 * From ASN.1 module "PKIX1Explicit88"
 * 	found in "../PKIX1Explicit88.asn"
 */

#include <asn_internal.h>

#include "X520CommonName.h"

static int permitted_alphabet_table_3[256] = {
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,	/*                  */
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,	/*                  */
1,0,0,0,0,0,0,1,1,1,0,1,1,1,1,1,	/* .      '() +,-./ */
1,1,1,1,1,1,1,1,1,1,1,0,0,1,0,1,	/* 0123456789:  = ? */
0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,	/*  ABCDEFGHIJKLMNO */
1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,	/* PQRSTUVWXYZ      */
0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,	/*  abcdefghijklmno */
1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,	/* pqrstuvwxyz      */
};

static int check_permitted_alphabet_3(const void *sptr) {
	int *table = permitted_alphabet_table_3;
	/* The underlying type is PrintableString */
	const PrintableString_t *st = (const PrintableString_t *)sptr;
	const uint8_t *ch = st->buf;
	const uint8_t *end = ch + st->size;
	
	for(; ch < end; ch++) {
		uint8_t cv = *ch;
		if(!table[cv]) return -1;
	}
	return 0;
}

static int check_permitted_alphabet_4(const void *sptr) {
	/* The underlying type is UniversalString */
	const UniversalString_t *st = (const UniversalString_t *)sptr;
	const uint8_t *ch = st->buf;
	const uint8_t *end = ch + st->size;
	
	if(st->size % 4) return -1; /* (size%4)! */
	for(; ch < end; ch += 4) {
		uint32_t cv = (ch[0] << 24)
				| (ch[1] << 16)
				| (ch[2] << 8)
				|  ch[3];
		if(!(cv <= 2147483647)) return -1;
	}
	return 0;
}

static int check_permitted_alphabet_6(const void *sptr) {
	/* The underlying type is BMPString */
	const BMPString_t *st = (const BMPString_t *)sptr;
	const uint8_t *ch = st->buf;
	const uint8_t *end = ch + st->size;
	
	if(st->size % 2) return -1; /* (size%2)! */
	for(; ch < end; ch += 2) {
		uint16_t cv = (ch[0] << 8)
				| ch[1];
		if(!(cv <= 65533)) return -1;
	}
	return 0;
}

static int
memb_teletexString_1_constraint(asn_TYPE_descriptor_t *td, const void *sptr,
			asn_app_consume_bytes_f *app_errlog, void *app_key) {
	const TeletexString_t *st = (const TeletexString_t *)sptr;
	size_t size;
	
	if(!sptr) {
		_ASN_ERRLOG(app_errlog, app_key,
			"%s: value not given (%s:%d)",
			td->name, __FILE__, __LINE__);
		return -1;
	}
	
	size = st->size;
	
	if((size >= 1 && size <= 64)) {
		/* Constraint check succeeded */
		return 0;
	} else {
		_ASN_ERRLOG(app_errlog, app_key,
			"%s: constraint failed (%s:%d)",
			td->name, __FILE__, __LINE__);
		return -1;
	}
}

static int
memb_printableString_1_constraint(asn_TYPE_descriptor_t *td, const void *sptr,
			asn_app_consume_bytes_f *app_errlog, void *app_key) {
	const PrintableString_t *st = (const PrintableString_t *)sptr;
	size_t size;
	
	if(!sptr) {
		_ASN_ERRLOG(app_errlog, app_key,
			"%s: value not given (%s:%d)",
			td->name, __FILE__, __LINE__);
		return -1;
	}
	
	size = st->size;
	
	if((size >= 1 && size <= 64)
		 && !check_permitted_alphabet_3(st)) {
		/* Constraint check succeeded */
		return 0;
	} else {
		_ASN_ERRLOG(app_errlog, app_key,
			"%s: constraint failed (%s:%d)",
			td->name, __FILE__, __LINE__);
		return -1;
	}
}

static int
memb_universalString_1_constraint(asn_TYPE_descriptor_t *td, const void *sptr,
			asn_app_consume_bytes_f *app_errlog, void *app_key) {
	const UniversalString_t *st = (const UniversalString_t *)sptr;
	size_t size;
	
	if(!sptr) {
		_ASN_ERRLOG(app_errlog, app_key,
			"%s: value not given (%s:%d)",
			td->name, __FILE__, __LINE__);
		return -1;
	}
	
	size = st->size >> 2;	/* 4 byte per character */
	
	if((size >= 1 && size <= 64)
		 && !check_permitted_alphabet_4(st)) {
		/* Constraint check succeeded */
		return 0;
	} else {
		_ASN_ERRLOG(app_errlog, app_key,
			"%s: constraint failed (%s:%d)",
			td->name, __FILE__, __LINE__);
		return -1;
	}
}

static int
memb_utf8String_1_constraint(asn_TYPE_descriptor_t *td, const void *sptr,
			asn_app_consume_bytes_f *app_errlog, void *app_key) {
	const UTF8String_t *st = (const UTF8String_t *)sptr;
	size_t size;
	
	if(!sptr) {
		_ASN_ERRLOG(app_errlog, app_key,
			"%s: value not given (%s:%d)",
			td->name, __FILE__, __LINE__);
		return -1;
	}
	
	size = UTF8String_length(st);
	if((ssize_t)size < 0) {
		_ASN_ERRLOG(app_errlog, app_key,
			"%s: UTF-8: broken encoding (%s:%d)",
			td->name, __FILE__, __LINE__);
		return -1;
	}
	
	if((size >= 1 && size <= 64)) {
		/* Constraint check succeeded */
		return 0;
	} else {
		_ASN_ERRLOG(app_errlog, app_key,
			"%s: constraint failed (%s:%d)",
			td->name, __FILE__, __LINE__);
		return -1;
	}
}

static int
memb_bmpString_1_constraint(asn_TYPE_descriptor_t *td, const void *sptr,
			asn_app_consume_bytes_f *app_errlog, void *app_key) {
	const BMPString_t *st = (const BMPString_t *)sptr;
	size_t size;
	
	if(!sptr) {
		_ASN_ERRLOG(app_errlog, app_key,
			"%s: value not given (%s:%d)",
			td->name, __FILE__, __LINE__);
		return -1;
	}
	
	size = st->size >> 1;	/* 2 byte per character */
	
	if((size >= 1 && size <= 64)
		 && !check_permitted_alphabet_6(st)) {
		/* Constraint check succeeded */
		return 0;
	} else {
		_ASN_ERRLOG(app_errlog, app_key,
			"%s: constraint failed (%s:%d)",
			td->name, __FILE__, __LINE__);
		return -1;
	}
}

static asn_TYPE_member_t asn_MBR_X520CommonName_1[] = {
	{ ATF_NOFLAGS, 0, offsetof(struct X520CommonName, choice.teletexString),
		(ASN_TAG_CLASS_UNIVERSAL | (20 << 2)),
		0,
		(void *)&asn_DEF_TeletexString,
		memb_teletexString_1_constraint,
		"teletexString"
		},
	{ ATF_NOFLAGS, 0, offsetof(struct X520CommonName, choice.printableString),
		(ASN_TAG_CLASS_UNIVERSAL | (19 << 2)),
		0,
		(void *)&asn_DEF_PrintableString,
		memb_printableString_1_constraint,
		"printableString"
		},
	{ ATF_NOFLAGS, 0, offsetof(struct X520CommonName, choice.universalString),
		(ASN_TAG_CLASS_UNIVERSAL | (28 << 2)),
		0,
		(void *)&asn_DEF_UniversalString,
		memb_universalString_1_constraint,
		"universalString"
		},
	{ ATF_NOFLAGS, 0, offsetof(struct X520CommonName, choice.utf8String),
		(ASN_TAG_CLASS_UNIVERSAL | (12 << 2)),
		0,
		(void *)&asn_DEF_UTF8String,
		memb_utf8String_1_constraint,
		"utf8String"
		},
	{ ATF_NOFLAGS, 0, offsetof(struct X520CommonName, choice.bmpString),
		(ASN_TAG_CLASS_UNIVERSAL | (30 << 2)),
		0,
		(void *)&asn_DEF_BMPString,
		memb_bmpString_1_constraint,
		"bmpString"
		},
};
static asn_TYPE_tag2member_t asn_MAP_X520CommonName_1_tag2el[] = {
    { (ASN_TAG_CLASS_UNIVERSAL | (12 << 2)), 3, 0, 0 }, /* utf8String at 103 */
    { (ASN_TAG_CLASS_UNIVERSAL | (19 << 2)), 1, 0, 0 }, /* printableString at 101 */
    { (ASN_TAG_CLASS_UNIVERSAL | (20 << 2)), 0, 0, 0 }, /* teletexString at 100 */
    { (ASN_TAG_CLASS_UNIVERSAL | (28 << 2)), 2, 0, 0 }, /* universalString at 102 */
    { (ASN_TAG_CLASS_UNIVERSAL | (30 << 2)), 4, 0, 0 } /* bmpString at 104 */
};
static asn_CHOICE_specifics_t asn_SPC_X520CommonName_1_specs = {
	sizeof(struct X520CommonName),
	offsetof(struct X520CommonName, _asn_ctx),
	offsetof(struct X520CommonName, present),
	sizeof(((struct X520CommonName *)0)->present),
	asn_MAP_X520CommonName_1_tag2el,
	5,	/* Count of tags in the map */
	0	/* Whether extensible */
};
asn_TYPE_descriptor_t asn_DEF_X520CommonName = {
	"X520CommonName",
	"X520CommonName",
	CHOICE_free,
	CHOICE_print,
	CHOICE_constraint,
	CHOICE_decode_ber,
	CHOICE_encode_der,
	CHOICE_decode_xer,
	CHOICE_encode_xer,
	CHOICE_outmost_tag,
	0,	/* No effective tags (pointer) */
	0,	/* No effective tags (count) */
	0,	/* No tags (pointer) */
	0,	/* No tags (count) */
	asn_MBR_X520CommonName_1,
	5,	/* Elements count */
	&asn_SPC_X520CommonName_1_specs	/* Additional specs */
};

