/*
  gssc.c

  Copyright (c) 2000 The Regents of the University of Michigan.
  All rights reserved.

  Copyright (c) 2000 Dug Song <dugsong@UMICH.EDU>.
  Copyright (c) 2002 Andy Adamson <andros@UMICH.EDU>.
  All rights reserved, all wrongs reversed.

  Redistribution and use in source and binary forms, with or without
  modification, are permitted provided that the following conditions
  are met:

  1. Redistributions of source code must retain the above copyright
     notice, this list of conditions and the following disclaimer.
  2. Redistributions in binary form must reproduce the above copyright
     notice, this list of conditions and the following disclaimer in the
     documentation and/or other materials provided with the distribution.
  3. Neither the name of the University nor the names of its
     contributors may be used to endorse or promote products derived
     from this software without specific prior written permission.

  THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESS OR IMPLIED
  WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
  DISCLAIMED. IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
  FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
  CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
  SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
  BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
  LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

  $Id: gssc.c,v 1.11 2002/02/12 22:38:35 andros Exp $
*/

#include <sys/types.h>
#include <rpc/rpc.h>
#include <stdio.h>
#include <stdlib.h>
#include "gss.h"
#define CA_RUN_AS_MACHINE  0x00000200


int
main(int argc, char *argv[])
{
	CLIENT *cl;
	GSS_BUFFER_T name, *namep;
	u_int id, *idp;
	gss_init_sec_context_arg init_sec_arg;
	gss_init_sec_context_res *init_sec_resp;
	gss_accept_sec_context_arg acpt_sec_arg;
	gss_accept_sec_context_res *acpt_sec_resp;
	
	if (argc != 4) {
		fprintf(stderr, "Usage: %s gid uid user\n", argv[0]);
		exit(1);
	}

	if ((cl = clnt_create("localhost", GSSPROG, GSSVERS, "udp")) == NULL) {
		clnt_pcreateerror("localhost");
		exit(1);
	}
	/* Get rid of the default authentication info */
	auth_destroy(cl->cl_auth);
	
	if ((cl->cl_auth = authunix_create_default()) == NULL) {
		clnt_pcreateerror(argv[1]);
		exit(1);
	}
	/* Try gid_to_name and back. */
	id = atoi(argv[1]);

	if ((namep = gid_to_name_1(&id, cl)) == NULL) {
		clnt_perror(cl, "gid_to_name");
		exit(1);
	}
	printf("gssc: gid_to_name: %d -> %.*s\n", id,
	       namep->GSS_BUFFER_T_len, namep->GSS_BUFFER_T_val);

	if ((idp = name_to_gid_1(namep, cl)) == NULL) {
		clnt_perror(cl, "name_to_gid");
		exit (1);
	}
	printf("gssc: name_to_gid: %.*s -> %d\n",
	       namep->GSS_BUFFER_T_len, namep->GSS_BUFFER_T_val, *idp);


	/* Try uid_to_name and back. */
	id = atoi(argv[2]);
	
	if ((namep = uid_to_name_1(&id, cl)) == NULL) {
		clnt_perror(cl, "uid_to_name");
		exit(1);
	}
	fprintf(stderr, "uid_to_name: %d -> %.*s\n",
		id, namep->GSS_BUFFER_T_len, namep->GSS_BUFFER_T_val);

	if ((idp = name_to_uid_1(namep, cl)) == NULL) {
		clnt_perror(cl, "name_to_uid");
		exit (1);
	}
	fprintf(stderr, "name_to_uid: %.*s -> %d\n",
		namep->GSS_BUFFER_T_len, namep->GSS_BUFFER_T_val, *idp);

	/* Try init_sec_context. */
	name.GSS_BUFFER_T_val = argv[3];
	name.GSS_BUFFER_T_len = strlen(argv[3]);
	
	if ((idp = name_to_uid_1(&name, cl)) == NULL) {
		clnt_perror(cl, "name_to_uid");
		exit (1);
	}
	memset(&init_sec_arg, 0, sizeof(init_sec_arg));
	init_sec_arg.uid = *idp; 
  init_sec_arg.flags |= CA_RUN_AS_MACHINE;
	init_sec_arg.target_name.GSS_BUFFER_T_val = "host";
	init_sec_arg.target_name.GSS_BUFFER_T_len = 4;

	if (!(init_sec_resp = gss_init_sec_context_1(&init_sec_arg, cl))) {
		clnt_perror(cl, "init_sec_context");
		exit(1);
	}
	fprintf(stderr, "init_sec_context: ctx_id: %p (len=%d) maj: %d "
		"min: %d tok: %p (len=%d) ret_flags: %d\n",
		init_sec_resp->ctx_id.GSS_CTX_ID_T_val,
		init_sec_resp->ctx_id.GSS_CTX_ID_T_len,
		init_sec_resp->maj_stat, init_sec_resp->min_stat,
		init_sec_resp->output_token.GSS_BUFFER_T_val,
		init_sec_resp->output_token.GSS_BUFFER_T_len,
		init_sec_resp->ret_flags);
	/* save ctx for continuation */
	init_sec_arg.ctx_id = init_sec_resp->ctx_id;

	/* Try accept_sec_context. */
	memset(&acpt_sec_arg, 0, sizeof(acpt_sec_arg));
	acpt_sec_arg.input_token = init_sec_resp->output_token;

	if (!(acpt_sec_resp = gss_accept_sec_context_1(&acpt_sec_arg, cl))) {
		clnt_perror(cl, "acpt_sec_context");
		                exit(1);
	}
	fprintf(stderr, "accept_sec_context: ctx_id: %p (len=%d) maj: %d "
		"min: %d src_name: %p (len=%d) tok: %p (len=%d) ret: %d\n",
		acpt_sec_resp->ctx_id.GSS_CTX_ID_T_val,
		acpt_sec_resp->ctx_id.GSS_CTX_ID_T_len,
		acpt_sec_resp->maj_stat, acpt_sec_resp->min_stat,
		acpt_sec_resp->src_name.GSS_BUFFER_T_val,
		acpt_sec_resp->src_name.GSS_BUFFER_T_len,
		acpt_sec_resp->output_token.GSS_BUFFER_T_val,
		acpt_sec_resp->output_token.GSS_BUFFER_T_len,
		acpt_sec_resp->ret_flags);
	
	/* Try init_sec_context. */
	init_sec_arg.input_token = acpt_sec_resp->output_token;
	
	if (!(init_sec_resp = gss_init_sec_context_1(&init_sec_arg, cl))) {
		clnt_perror(cl, "init_sec_context");
		exit(1);
	}
	fprintf(stderr, "init_sec_context: ctx_id: %p maj: %d min: %d "
		"tok: %p (len=%d) ret_flags: %d\n",
		init_sec_resp->ctx_id.GSS_CTX_ID_T_val,
		init_sec_resp->maj_stat, init_sec_resp->min_stat,
		init_sec_resp->output_token.GSS_BUFFER_T_val,
		init_sec_resp->output_token.GSS_BUFFER_T_len,
		init_sec_resp->ret_flags);
	
	clnt_destroy(cl);
	
	exit (0);
}
