/*
  gssd.x

  Copyright (c) 2000 The Regents of the University of Michigan.
  All rights reserved.

  Copyright (c) 
  2000 Dug Song <dugsong@UMICH.EDU>,
  2001 Andy Adamson <andros@UMICH.EDU>.
  All rights reserved, all wrongs reversed.

  Redistribution and use in source and binary forms, with or without
  modification, are permitted provided that the following conditions
  are met:

  1. Redistributions of source code must retain the above copyright
     notice, this list of conditions and the following disclaimer.
  2. Redistributions in binary form must reproduce the above copyright
     notice, this list of conditions and the following disclaimer in the
     documentation and/or other materials provided with the distribution.
  3. Neither the name of the University nor the names of its
     contributors may be used to endorse or promote products derived
     from this software without specific prior written permission.

  THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESS OR IMPLIED
  WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
  DISCLAIMED. IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
  FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
  CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
  SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
  BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
  LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

  $Id: gss.x,v 1.8 2002/02/12 22:38:35 andros Exp $
*/

%#include <sys/types.h>

typedef unsigned int	OM_UINT32;
typedef opaque		GSS_CTX_ID_T<>;
typedef opaque		GSS_CRED_ID_T<>;
typedef opaque		GSS_OID<>;
typedef opaque		GSS_BUFFER_T<>;

struct gss_init_sec_context_arg {
        unsigned int	uid;		/* caller's uid */       
        unsigned int	flags;		/* to signal use of MACHINE CREDS */       
					/* claimant_cred_handle */
	GSS_CTX_ID_T	ctx_id;		
	GSS_BUFFER_T    target_name;	
	GSS_OID         mech;		
					/* req_flags */
					/* time_req */
					/* input_channel_bindings */
	GSS_BUFFER_T    input_token;
};

struct gss_init_sec_context_res {
	GSS_CTX_ID_T	ctx_id;
	OM_UINT32	maj_stat;
	OM_UINT32	min_stat;
					/* actual_mech_type */
	GSS_BUFFER_T	output_token;
	OM_UINT32	ret_flags;
					/* time_rec */
};

struct gss_accept_sec_context_arg {
	GSS_CTX_ID_T	ctx_id;
					/* verifier cred handle */
	GSS_BUFFER_T	input_token;
					/* input channel bindings */
};

struct gss_accept_sec_context_res {
	GSS_CTX_ID_T	ctx_id;
	OM_UINT32	maj_stat;
	OM_UINT32	min_stat;
	GSS_BUFFER_T	src_name;
					/* mech type */
	GSS_BUFFER_T	output_token;
	OM_UINT32	ret_flags;
					/* time_rec */
					/* delegated cred handle */
};

struct gss_import_sec_context_arg {
	GSS_CTX_ID_T	ctx_id;
};

struct gss_import_sec_context_res {
	OM_UINT32	maj_stat;
	OM_UINT32	min_stat;
  GSS_BUFFER_T ctx_token;
};

program GSSPROG {
	version GSSVERS {

		/* Unix/GSS name-to-uid mapping. */
		unsigned int NAME_TO_UID(GSS_BUFFER_T)			= 1;
			
		/* Unix uid-to-name mapping. */
		GSS_BUFFER_T UID_TO_NAME(unsigned int)			= 2;

		/* Unix name-to-gid mapping. */
		unsigned int NAME_TO_GID(GSS_BUFFER_T)			= 3;

		/* Unix gid-to-name mapping. */
		GSS_BUFFER_T GID_TO_NAME(unsigned int)			= 4;
		
		/* Initialize security context. */
		gss_init_sec_context_res
			GSS_INIT_SEC_CONTEXT(gss_init_sec_context_arg)	= 5;

		/* Accept security context. */
		gss_accept_sec_context_res
			GSS_ACCEPT_SEC_CONTEXT(gss_accept_sec_context_arg) = 6;
		
		/* Import security context. */
		gss_import_sec_context_res
			GSS_IMPORT_SEC_CONTEXT(gss_import_sec_context_arg) = 7;
		
	} = 1;
} = 100666;

/* 5000. */
