#include <linux/posix_types.h>
#include <asm/posix_types.h>
#undef __FD_CLR
#undef __FD_SET
#undef __FD_ISSET
#undef __FD_ZERO
#undef __NFDBITS
#undef __FDMASK

#include <unistd.h>
#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <netdb.h>
#include <rpc/rpc.h>
#include <rpc/pmap_prot.h>
#include <rpc/pmap_clnt.h>
#include <sys/socket.h>
#include <sys/time.h>
#include <sys/utsname.h>
#include <sys/stat.h>
#include <netinet/in.h>
#include <arpa/inet.h>

#include "sundries.h"
#include "nfsmount.h"

#define NFS_NEED_KERNEL_TYPES
/*#include <linux/uio.h>*/
#include <linux/nfs.h>
#include "mount_constants.h"
#include <linux/nfs4_mount.h>
#undef NFS_NEED_KERNEL_TYPES

#include "nls.h"

#include "../defines.h"		/* for HAVE_inet_aton */

#define MAKE_VERSION(p,q,r)	(65536*(p) + 256*(q) + (r))

#ifdef HAVE_NFSV3
#ifdef NFSV4
#define MAX_NFSPROT ((nfs_mount_version >= 4) ? 3 : 2)
#else /*NFSV4*/
#define MAX_NFSPROT ((nfs_mount_version >= 4) ? 4 : 2)
#endif /*NFSV4*/
#else
#define MAX_NFSPROT 2
#endif

/* Pull these in from nfsmount.c for now */
int linux_version_code(void);
int get_ip_dot_addr(char *ip_dot);

int get_ip_dot_addr(char *ip_dot)
{
  struct hostent *h;
  struct in_addr in;
  char *addr;
  char name[128];
  int err = 0;
  
  err = gethostname(name,128);
  if(err == -1) {
    perror("gethostname failed");
    return -1;
  }
  
  h = gethostbyname(name);
  if(!h) {
    perror("gethostbyname failed\n");
    return -1;
  }
  
  memcpy(&in.s_addr,*h->h_addr_list,h->h_length);
  addr = inet_ntoa(in);
  memcpy(ip_dot,addr,strlen(addr));
  return 0;
}

/*
 * nfs_mount_version according to the kernel sources seen at compile time.
 */
static int nfs_mount_version = KERNEL_NFS_MOUNT_VERSION;

int nfs4mount(const char *spec, const char *node, int *flags,
	      char **extra_opts, char **mount_opts, int running_bg)
{
  static char *prev_bg_host;
  char hostdir[1024];
  CLIENT *mclient;
  char *hostname;
  char *dirname;
  char *old_opts;
  char *mounthost=NULL;
  char new_opts[1024];
  struct timeval total_timeout;
  enum clnt_stat clnt_stat;
  
  static struct nfs4_mount_data data;
  
  char *opt, *opteq;
  int val;
  struct hostent *hp;
  struct sockaddr_in server_addr;
  struct sockaddr_in mount_server_addr;
  struct pmap* pm_mnt;
  int msock, fsock;
  struct timeval retry_timeout;
  union {
    struct fhstatus nfsv2;
    struct mountres3 nfsv3;
  } status;
  struct stat statbuf;
  char *s;
  int port;
  int mountport;
  int proto;
  int bg;
  int soft;
  int intr;
  int posix;
  int nocto;
  int noac;
  int nolock;
  int retry;
  int tcp;
  int mountprog;
  int mountvers;
  int nfsprog;
  int nfsvers;
  int retval;
  
  int strict_locking;
  int silly_rename;
  int err = 0;
  
  time_t t;
  time_t prevt;
  time_t timeout;
  
  nfs_mount_version = NFS4_MOUNT_VERSION;
  
  retval = EX_FAIL;
  msock = fsock = -1;
  mclient = NULL;
  if (strlen(spec) >= sizeof(hostdir)) {
    fprintf(stderr, _("mount: "
		      "excessively long host:dir argument\n"));
    goto fail;
  }
  strcpy(hostdir, spec);
  if ((s = strchr(hostdir, ':'))) {
    hostname = hostdir;
    dirname = s + 1;
    *s = '\0';
    /* Ignore all but first hostname in replicated mounts
       until they can be fully supported. (mack@sgi.com) */
    if ((s = strchr(hostdir, ','))) {
      *s = '\0';
      fprintf(stderr, _("mount: warning: "
			"multiple hostnames not supported\n"));
    }
  } else {
    fprintf(stderr, _("mount: "
		      "directory to mount not in host:dir format\n"));
    goto fail;
  }
  
  server_addr.sin_family = AF_INET;
#ifdef HAVE_inet_aton
  if (!inet_aton(hostname, &server_addr.sin_addr))
#endif
    {
      if ((hp = gethostbyname(hostname)) == NULL) {
	fprintf(stderr, _("mount: can't get address for %s\n"),
		hostname);
	goto fail;
      } else {
	if (hp->h_length > sizeof(struct in_addr)) {
	  fprintf(stderr,
		  _("mount: got bad hp->h_length\n"));
	  hp->h_length = sizeof(struct in_addr);
	}
	memcpy(&server_addr.sin_addr,
	       hp->h_addr, hp->h_length);
      }
    }
  
  memcpy (&mount_server_addr, &server_addr, sizeof (mount_server_addr));
  
  /* add IP address to mtab options for use when unmounting */
  
  s = inet_ntoa(server_addr.sin_addr);
  old_opts = *extra_opts;
  if (!old_opts)
    old_opts = "";
  if (strlen(old_opts) + strlen(s) + 10 >= sizeof(new_opts)) {
    fprintf(stderr, _("mount: "
		      "excessively long option argument\n"));
    goto fail;
  }
  sprintf(new_opts, "%s%saddr=%s",
	  old_opts, *old_opts ? "," : "", s);
  *extra_opts = xstrdup(new_opts);
  
  /* Set default options.
   * rsize/wsize (and bsize, for ver >= 3) are left 0 in order to
   * let the kernel decide.
   * timeo is filled in after we know whether it'll be TCP or UDP. */
  memset(&data, 0, sizeof(data));
  data.retrans	= 3;
  data.acregmin	= 3;
  data.acregmax	= 60;
  data.acdirmin	= 30;
  data.acdirmax	= 60;
#if NFS_MOUNT_VERSION >= 2
  data.namlen	= NAME_MAX;
#endif
  
  if(strlen(dirname) >255)
    printf("MOUNT error - mount path too long\n");
  else {
    strcpy(data.mnt_path,dirname);
    printf("MOUNT - mount path %s added to nfs_mount_data\n",
	   data.mnt_path);
  }
  memset(data.ipaddr,0,16);
  err = get_ip_dot_addr(data.ipaddr);
  
  printf("IPADDR: %s, status %d\n",data.ipaddr,err);	
  
  bg = 0;
  soft = 0;
  intr = 0;
  posix = 0;
  nocto = 0;
  nolock = 0;
  noac = 0;
  retry = 10000;		/* 10000 minutes ~ 1 week */
  tcp = 0;
  
  mountprog = MOUNTPROG;
  mountvers = 0;
  port = 0;
  mountport = 0;
  nfsprog = NFS_PROGRAM;
  nfsvers = 0;
  
  strict_locking = 0;
  silly_rename = 1;
  
  /* parse options */
  
  for (opt = strtok(old_opts, ","); opt; opt = strtok(NULL, ",")) {
    if ((opteq = strchr(opt, '='))) {
      val = atoi(opteq + 1);	
      *opteq = '\0';
      if (!strcmp(opt, "rsize"))
	data.rsize = val;
      else if (!strcmp(opt, "wsize"))
	data.wsize = val;
      else if (!strcmp(opt, "timeo"))
	data.timeo = val;
      else if (!strcmp(opt, "retrans"))
	data.retrans = val;
      else if (!strcmp(opt, "acregmin"))
	data.acregmin = val;
      else if (!strcmp(opt, "acregmax"))
	data.acregmax = val;
      else if (!strcmp(opt, "acdirmin"))
	data.acdirmin = val;
      else if (!strcmp(opt, "acdirmax"))
	data.acdirmax = val;
      else if (!strcmp(opt, "actimeo")) {
	data.acregmin = val;
	data.acregmax = val;
	data.acdirmin = val;
	data.acdirmax = val;
      }
      else if (!strcmp(opt, "retry"))
	retry = val;
      else if (!strcmp(opt, "port"))
	port = val;
      else if (!strcmp(opt, "mountport"))
	mountport = val;
      else if (!strcmp(opt, "mounthost"))
	mounthost=xstrndup(opteq+1,
			   strcspn(opteq+1," \t\n\r,"));
      else if (!strcmp(opt, "mountprog"))
	mountprog = val;
      else if (!strcmp(opt, "mountvers"))
	mountvers = val;
      else if (!strcmp(opt, "nfsprog"))
	nfsprog = val;
      else if (!strcmp(opt, "nfsvers") ||
	       !strcmp(opt, "vers"))
	nfsvers = val;
      else if (!strcmp(opt, "proto")) {
	if (!strncmp(opteq+1, "tcp", 3))
	  tcp = 1;
	else if (!strncmp(opteq+1, "udp", 3))
	  tcp = 0;
	else
	  printf(_("Warning: Unrecognized proto= option.\n"));
      } else if (!strcmp(opt, "namlen")) {
#if NFS_MOUNT_VERSION >= 2
	if (nfs_mount_version >= 2)
	  data.namlen = val;
	else
#endif
	  printf(_("Warning: Option namlen is not supported.\n"));
      } else if (!strcmp(opt, "addr"))
				/* ignore */;
      else {
	printf(_("unknown nfs mount parameter: "
		 "%s=%d\n"), opt, val);
	goto fail;
      }
    }
    else {
      val = 1;
      if (!strncmp(opt, "no", 2)) {
	val = 0;
	opt += 2;
      }
      if (!strcmp(opt, "bg")) 
	bg = val;
      else if (!strcmp(opt, "fg")) 
	bg = !val;
      else if (!strcmp(opt, "soft"))
	soft = val;
      else if (!strcmp(opt, "hard"))
	soft = !val;
      else if (!strcmp(opt, "intr"))
	intr = val;
      else if (!strcmp(opt, "posix"))
	posix = val;
      else if (!strcmp(opt, "cto"))
	nocto = !val;
      else if (!strcmp(opt, "ac"))
	noac = !val;
      else if (!strcmp(opt, "tcp"))
	tcp = val;
      else if (!strcmp(opt, "udp"))
	tcp = !val;
      else if (!strcmp(opt, "lock")) {
	if (nfs_mount_version >= 3)
	  nolock = !val;
	else
	  printf(_("Warning: option nolock is not supported.\n"));
      }
      
      else if (!strcmp(opt, "strictlock"))
	strict_locking = 1;
      else if (!strcmp(opt, "nosilly"))
	silly_rename = 0;
      
      else {
	if (!sloppy) {
	  printf(_("unknown nfs mount option: "
		   "%s%s\n"), val ? "" : _("no"), opt);
	  goto fail;
	}
      }
    }
  }
  proto = (tcp) ? IPPROTO_TCP : IPPROTO_UDP;
  
  data.strict_locking = strict_locking;
  data.silly_rename = silly_rename;
  data.flags = (soft ? NFS4_MOUNT_SOFT : 0)
    | (intr ? NFS4_MOUNT_INTR : 0)
    | (posix ? NFS4_MOUNT_POSIX : 0)
    | (nocto ? NFS4_MOUNT_NOCTO : 0)
    | (noac ? NFS4_MOUNT_NOAC : 0) 
    | (tcp ? NFS4_MOUNT_TCP : 0);
  
  if (nfsvers > MAX_NFSPROT) {
    fprintf(stderr, "NFSv%d not supported!\n", nfsvers);
    return 0;
  }
  if (mountvers > MAX_NFSPROT) {
    fprintf(stderr, "NFSv%d not supported!\n", nfsvers);
    return 0;
  }
  if (nfsvers && !mountvers)
    mountvers = (nfsvers < 3) ? 1 : nfsvers;
  if (nfsvers && nfsvers < mountvers) {
    mountvers = nfsvers;
  }
  
  /* Adjust options if none specified */
  if (!data.timeo)
    data.timeo = tcp ? 70 : 7;
  
#ifdef NFS_MOUNT_DEBUG
  printf("rsize = %d, wsize = %d, timeo = %d, retrans = %d\n",
	 data.rsize, data.wsize, data.timeo, data.retrans);
  printf("acreg (min, max) = (%d, %d), acdir (min, max) = (%d, %d)\n",
	 data.acregmin, data.acregmax, data.acdirmin, data.acdirmax);
  printf("port = %d, bg = %d, retry = %d, flags = %.8x\n",
	 port, bg, retry, data.flags);
  printf("mountprog = %d, mountvers = %d, nfsprog = %d, nfsvers = %d\n",
	 mountprog, mountvers, nfsprog, nfsvers);
  
  printf("soft = %d, intr = %d, posix = %d, nocto = %d, noac = %d, tcp %d\n",
	 (data.flags & NFS4_MOUNT_SOFT) != 0,
	 (data.flags & NFS4_MOUNT_INTR) != 0,
	 (data.flags & NFS4_MOUNT_POSIX) != 0,
	 (data.flags & NFS4_MOUNT_NOCTO) != 0,
	 (data.flags & NFS4_MOUNT_NOAC) != 0,
	 (data.flags & NFS4_MOUNT_TCP) != 0);
  
#endif
  
  data.version = nfs_mount_version;
  *mount_opts = (char *) &data;
  
  if (*flags & MS_REMOUNT)
    return 0;
  
  /*
   * If the previous mount operation on the same host was
   * backgrounded, and the "bg" for this mount is also set,
   * give up immediately, to avoid the initial timeout.
   */
  if (bg && !running_bg &&
      prev_bg_host && strcmp(hostname, prev_bg_host) == 0) {
    if (retry > 0)
      retval = EX_BG;
    return retval;
  }
  
  /* create mount deamon client */
  /* See if the nfs host = mount host. */
  if (mounthost) {
    if (mounthost[0] >= '0' && mounthost[0] <= '9') {
      mount_server_addr.sin_family = AF_INET;
      mount_server_addr.sin_addr.s_addr = inet_addr(hostname);
    } else {
      if ((hp = gethostbyname(mounthost)) == NULL) {
	fprintf(stderr, _("mount: can't get address for %s\n"),
		hostname);
	goto fail;
      } else {
	if (hp->h_length > sizeof(struct in_addr)) {
	  fprintf(stderr,
		  _("mount: got bad hp->h_length?\n"));
	  hp->h_length = sizeof(struct in_addr);
	}
	mount_server_addr.sin_family = AF_INET;
	memcpy(&mount_server_addr.sin_addr,
	       hp->h_addr, hp->h_length);
      }
    }
  }
  
  data.flags |= NFS_MOUNT_VER4;
  
  /* create nfs socket for kernel */
  
  if (tcp) {
    if (nfs_mount_version < 3) {
      printf(_("NFS over TCP is not supported.\n"));
      goto fail;
    }
    fsock = socket(AF_INET, SOCK_STREAM, IPPROTO_TCP);
  } else
    fsock = socket(AF_INET, SOCK_DGRAM, IPPROTO_UDP);
  if (fsock < 0) {
    perror(_("nfs socket"));
    goto fail;
  }
  if (bindresvport(fsock, 0) < 0) {
    perror(_("nfs bindresvport"));
    goto fail;
  }
  if (port == 0) {
    server_addr.sin_port = PMAPPORT;
    port = pmap_getport(&server_addr, nfsprog, nfsvers,
			tcp ? IPPROTO_TCP : IPPROTO_UDP);
    if (port == 0)
      port = NFS_PORT;
#ifdef NFS_MOUNT_DEBUG
    else
      printf(_("used portmapper to find NFS port\n"));
#endif
  }
#ifdef NFS_MOUNT_DEBUG
  printf(_("using port %d for nfs deamon\n"), port);
#endif
  server_addr.sin_port = htons(port);
  /*
   * connect() the socket for kernels 1.3.10 and below only,
   * to avoid problems with multihomed hosts.
   * --Swen
   */
  if (linux_version_code() <= 66314
      && connect(fsock, (struct sockaddr *) &server_addr,
		 sizeof (server_addr)) < 0) {
    perror(_("nfs connect"));
    goto fail;
  }
  
  /* prepare data structure for kernel */
  
  data.fd = fsock;
  memcpy((char *) &data.addr, (char *) &server_addr, sizeof(data.addr));
  strncpy(data.hostname, hostname, sizeof(data.hostname));
  printf("NFSV4: data.hostname: %s\n",data.hostname);
  
  /* clean up */
  
  close(msock);
  return 0;
  
  /* abort */
  
 fail:
  if (msock != -1) {
    if (mclient) {
      auth_destroy(mclient->cl_auth);
      clnt_destroy(mclient);
    }
    close(msock);
  }
  if (fsock != -1)
    close(fsock);
  return retval;
}
