%{
/*
 * exportfs4.l
 *
 *  Copyright (c) 2000 The Regents of the University of Michigan.
 *  All rights reserved.
 *
 *  Jake Moilanen <jmoilane@umich.edu>
 *  Kendrick Smith <kmsmith@umich.edu>
 *
 *  Redistribution and use in source and binary forms, with or without
 *  modification, are permitted provided that the following conditions
 *  are met:
 *
 *  1. Redistributions of source code must retain the above copyright
 *     notice, this list of conditions and the following disclaimer.
 *  2. Redistributions in binary form must reproduce the above copyright
 *     notice, this list of conditions and the following disclaimer in the
 *     documentation and/or other materials provided with the distribution.
 *  3. Neither the name of the University nor the names of its
 *     contributors may be used to endorse or promote products derived
 *     from this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESS OR IMPLIED
 *  WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 *  DISCLAIMED. IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 *  FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 *  CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 *  SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
 *  BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 *  LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 *  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 *  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include <stdlib.h>
#include <string.h>
#include "exportfs4.h"
#define YYSTYPE char *
#include "y.tab.h"             /* Token codes from the parser */

extern YYSTYPE yylval;

char *
newstr(char * str) {
  char * new;
  if (!(new = strdup(str))) {
    fprintf(stderr,"exportfs4: out of memory in newstr");
    destroy_server();
  }
  return new;
}

int lineno = 1;
static int first_time = 1;
%}

%s EXPECT_PATH EXPECT_SEC

path ([A-Za-z0-9_.~\-\/]+)
ro ([rR][oO])
rw ([rR][wW])
pseudo ([pP][sS][eE][uU][dD][oO])
sec ([sS][eE][cC])
secopt ([a-zA-Z0-9]+)
ws ([ \t\r]+)
newline (\n)

%%
%{
{
  if (first_time) {
    /* Paths are expected at the beginning of a line and after a 'pseudo' */
    BEGIN(EXPECT_PATH);
    first_time = 0;
  }
}
%}

 /* Paths */
{newline}               { BEGIN(EXPECT_PATH);
                           return NL; }
{pseudo}                { BEGIN(EXPECT_PATH);
                          return PSEUDO; }
<EXPECT_PATH>{path}	{ yylval = newstr(yytext);
                          BEGIN(INITIAL);
			  return PATH; }

 /* Security */
<EXPECT_SEC>{secopt}    { yylval = newstr(yytext);
                          BEGIN(INITIAL);
			  return SECTYPE; }
{sec}                   { BEGIN(EXPECT_SEC);
                          return SEC; }

 /* Permissions */
{ro}                    { return RO; }
{rw}                    { return RW; }

 /* Return comma, parentheses, colon, equals sign as themselves */
,|\)|\(|:|=             { return *yytext; }

 /* Ignore whitespace and comments */
{ws}+
#.*

 /* Anything else is an error. */
. { fprintf(stderr, "parse error on line %d\n", lineno); destroy_server(); }

%%

void
yyerror(const char *msg)
{
  fprintf(stderr, "%d: %s at '%s'\n", lineno, msg, yytext);
  destroy_server();
}
