# setup.sh
#
# Copyright (c) 2004 Marius Aamodt Eriksen <marius@citi.umich.edu>
# All rights reserved.
#
# $Id: setup.sh,v 1.6 2004/06/07 21:09:32 marius Exp $

#!/bin/sh

PREFIX=""

if [ $# -eq 2 ]; then
    PREFIX=/tmp
elif [ $# -eq 3 ]; then
    PREFIX=$3
else
    echo "Usage: `basename $0` which [setup|clean] [destination]" >&2
    exit 1
fi

MODE=$2
WHICH=$1

case $WHICH in
    [Ff]ree[Bb][Ss][Dd])
        WHICH="FreeBSD"
        ;;
    [Dd]arwin)
        WHICH="Darwin"
        ;;
    *)
	echo "\"$WHICH\" not valid.  (FreeBSD and Darwin supported)." >&2
	exit 1
esac

case $MODE in 
    setup)
	if [ -d $PREFIX/$WHICH ]; then
	    echo "$PREFIX/$WHICH already exists" >&2
	    exit 1
	fi

	mkdir $PREFIX/$WHICH
	ln -fs $PWD/${WHICH}-nfsxclient $PREFIX/$WHICH/nfsxclient
	ln -fs $PWD/${WHICH}-nfsx $PREFIX/$WHICH/nfsx	
	ln -fs $PWD/Common-nfs/* $PREFIX/$WHICH/nfsx
	ln -fs $PWD/Common-rpc $PREFIX/$WHICH/rpcx
	ln -fs $PWD/Common-gssd $PREFIX/$WHICH/gssd
	ln -fs $PWD/Common-gssd/Makefile $PREFIX/$WHICH/Makefile-gssd
	ln -fs $PWD/Common-rpcd $PREFIX/$WHICH/rpcd
	ln -fs $PWD/Common-rpcd/Makefile $PREFIX/$WHICH/Makefile-rpcd
	ln -fs $PWD/nfs4client $PREFIX/$WHICH
	ln -fs $PWD/${WHICH}-nfs4client/* $PREFIX/$WHICH/nfs4client
	ln -fs $PWD/${WHICH}-Makefile $PREFIX/$WHICH/Makefile

	if [ $WHICH = "Darwin" ]; then
	    ln -fs $PWD/Util/rkext.sh $PREFIX/Darwin/rkext.sh
	    ln -fs $PWD/Util/runkext.sh $PREFIX/Darwin/runkext.sh
	    ln -fs $PWD/Util/kext.sh $PREFIX/Darwin/kext.sh
	    ln -fs $PWD/Util/unkext.sh $PREFIX/Darwin/unkext.sh
	fi

	ln -fs $PWD/Common-idmapd $PREFIX/$WHICH/idmapd
	ln -fs $PWD/Common-rpc $PREFIX/$WHICH/idmapd/rpcx
	ln -fs $PWD/Common-gssd $PREFIX/$WHICH/gssd
	ln -fs $PWD/${WHICH}-userland $PREFIX/$WHICH/userland

	if [ $WHICH = "Darwin" ]; then
	    cp -r $PWD/Darwin-kextskel $PREFIX/Darwin/NFSv4.kext
	fi
	if [ $WHICH = "FreeBSD" ]; then
	    mkdir $PREFIX/$WHICH/obj
	    ln -fs $PWD/FreeBSD-mount_nfs4 $PREFIX/$WHICH/mount_nfsv4
	    ln -fs $PWD/build-load-mount.sh $PREFIX/$WHICH
	fi
	;;
    clean)
	rm -rf $PREFIX/$WHICH
	find $PWD -type l -exec rm {} ';'

	;;
    *)
	echo "The mode \"$MODE\" is not valid" >&2
	exit 1
	;;
esac
