/*
 * copyright (c) 2004
 * the regents of the university of michigan
 * all rights reserved
 * 
 * permission is granted to use, copy, create derivative works and redistribute
 * this software and such derivative works for any purpose, so long as the name
 * of the university of michigan is not used in any advertising or publicity
 * pertaining to the use or distribution of this software without specific,
 * written prior authorization.  if the above copyright notice or any other
 * identification of the university of michigan is included in any copy of any
 * portion of this software, then the disclaimer below must also be included.
 * 
 * this software is provided as is, without representation from the university
 * of michigan as to its fitness for any purpose, and without warranty by the
 * university of michigan of any kind, either express or implied, including
 * without limitation the implied warranties of merchantability and fitness for
 * a particular purpose. the regents of the university of michigan shall not be
 * liable for any damages, including special, indirect, incidental, or
 * consequential damages, with respect to any claim arising out of or in
 * connection with the use of the software, even if it has been or is hereafter
 * advised of the possibility of such damages.
 */

#ifndef _NFSX_VFSOPS_H
#define _NFSX_VFSOPS_H

int nfsx_sysctl(int *, u_int, void *, size_t *, void *, size_t, struct proc *);
int nfsx_iosize __P((struct nfsmount *nmp));
int mountnfsx __P((struct nfs_args *,struct mount *,
		      struct mbuf *,char *,char *,struct vnode **));
int nfsx_mount __P(( struct mount *mp, char *path, caddr_t data,
		       struct nameidata *ndp, struct proc *p));
int nfsx_start __P(( struct mount *mp, int flags,
		       struct proc *p));


int nfsx_quotactl __P(( struct mount *mp, int cmds, uid_t uid,
			  caddr_t arg, struct proc *p));
int nfsx_statfs __P(( struct mount *mp, struct statfs *sbp,
			struct proc *p));
int nfsx_vptofh __P(( struct vnode *vp, struct fid *fhp));
int nfsx_fhtovp __P((struct mount *mp, struct fid *fhp,
			struct mbuf *nam, struct vnode **vpp,
			int *exflagsp, struct ucred **credanonp));
int nfsx_vget __P((struct mount *, void *, struct vnode **));

void nfsx_convert_oargs __P((struct nfs_args *args,
				struct onfs_args *oargs));

#ifdef __FreeBSD__
vfs_root_t nfsx_root;
vfs_sync_t nfsx_sync;
#endif

#endif /* _NFSX_VFSOPS_H */
