/*
 * copyright (c) 2004
 * the regents of the university of michigan
 * all rights reserved
 * 
 * permission is granted to use, copy, create derivative works and redistribute
 * this software and such derivative works for any purpose, so long as the name
 * of the university of michigan is not used in any advertising or publicity
 * pertaining to the use or distribution of this software without specific,
 * written prior authorization.  if the above copyright notice or any other
 * identification of the university of michigan is included in any copy of any
 * portion of this software, then the disclaimer below must also be included.
 * 
 * this software is provided as is, without representation from the university
 * of michigan as to its fitness for any purpose, and without warranty by the
 * university of michigan of any kind, either express or implied, including
 * without limitation the implied warranties of merchantability and fitness for
 * a particular purpose. the regents of the university of michigan shall not be
 * liable for any damages, including special, indirect, incidental, or
 * consequential damages, with respect to any claim arising out of or in
 * connection with the use of the software, even if it has been or is hereafter
 * advised of the possibility of such damages.
 */

#include <sys/systm.h>
#include <sys/mount.h>
#include <sys/syscall.h>

#include <mach/vm_types.h>
#include <mach/kmod.h>

#include <nfs4client/nfs4_glue.h>

#include <rpc/rpcclnt.h>
#include <nfs/rpcv2.h>
#include <nfs/nfsproto.h>
#include <nfs/nfs.h>
#include <nfs4client/nfs4.h>

int nfs4_darwin_syscall(struct proc *, void *,int *);

struct vfsconf nfs4_vfsconf;

extern struct vfsops nfs4_vfsops;
extern int maxvfsconf;
extern int nfs4_renewd_invoked;

kern_return_t
nfs4_modload(struct kmod_info *kip, void *data)
{
	if (sysent[NFS4_SYSCALL].sy_call != nosys) {
		printf("nfs4: syscall %d already in use; bailing out.\n", NFS4_SYSCALL);
		return (KERN_FAILURE);
	}

	bzero(&nfs4_vfsconf, sizeof(nfs4_vfsconf));
	strcpy(nfs4_vfsconf.vfc_name, "nfs4");
	nfs4_vfsconf.vfc_vfsops = &nfs4_vfsops;
	nfs4_vfsconf.vfc_typenum = maxvfsconf++;
	nfs4_vfsconf.vfc_flags = MNT_NODEV;

	if (vfsconf_add(&nfs4_vfsconf) != 0)
		return (KERN_FAILURE);

	sysent[NFS4_SYSCALL].sy_call = nfs4_darwin_syscall;
	sysent[NFS4_SYSCALL].sy_narg = 0;
#ifdef KERNEL_FUNNEL
	sysent[NFS4_SYSCALL].sy_funnel = KERNEL_FUNNEL;
#endif

/* 	PE_enter_debugger("debug"); */

	return (KERN_SUCCESS);
}

kern_return_t
nfs4_modunload(struct kmod_info *kip, void *data)
{
	/* XXX mount check? */

	if (nfs4_renewd_invoked || vfsconf_del("nfs4") != 0)
		return (KERN_FAILURE);

	rpcclnt_uninit();

	sysent[NFS4_SYSCALL].sy_call = nosys;

	return (KERN_SUCCESS);
}

KMOD_EXPLICIT_DECL(edu.umich.citi.filesystems.nfsv4,
    "1.0", nfs4_modload, nfs4_modunload);
