/*
 * copyright (c) 2004
 * the regents of the university of michigan
 * all rights reserved
 * 
 * permission is granted to use, copy, create derivative works and redistribute
 * this software and such derivative works for any purpose, so long as the name
 * of the university of michigan is not used in any advertising or publicity
 * pertaining to the use or distribution of this software without specific,
 * written prior authorization.  if the above copyright notice or any other
 * identification of the university of michigan is included in any copy of any
 * portion of this software, then the disclaimer below must also be included.
 * 
 * this software is provided as is, without representation from the university
 * of michigan as to its fitness for any purpose, and without warranty by the
 * university of michigan of any kind, either express or implied, including
 * without limitation the implied warranties of merchantability and fitness for
 * a particular purpose. the regents of the university of michigan shall not be
 * liable for any damages, including special, indirect, incidental, or
 * consequential damages, with respect to any claim arising out of or in
 * connection with the use of the software, even if it has been or is hereafter
 * advised of the possibility of such damages.
 */

#ifndef _NFSX_VNOPS_H
#define _NFSX_VNOPS_H

int nfsxspec_read __P((struct vop_read_args *));
int nfsxspec_write __P((struct vop_write_args *));
int nfsxspec_close __P((struct vop_close_args *));
int nfsxspec_access __P((struct vop_access_args *));

int nfsxfifo_read __P((struct vop_read_args *));
int nfsxfifo_write __P((struct vop_write_args *));
int nfsxfifo_close __P((struct vop_close_args *));

#define nfsx_poll vop_nopoll
int nfsx_close __P((struct vop_close_args *));
int nfsx_setattr __P((struct vop_setattr_args *));
int nfsx_read __P((struct vop_read_args *));
int nfsx_readlink __P((struct vop_readlink_args *));
int nfsx_mknod __P((struct vop_mknod_args *));
int nfsx_remove __P((struct vop_remove_args *));
/* int nfsx_removeit __P((struct sillyrename *)); */
int nfsx_rename __P((struct vop_rename_args *));
int nfsx_readdir __P((struct vop_readdir_args *));

int nfsx_mmap __P((struct vop_mmap_args *));
int nfsx_fsync __P((struct vop_fsync_args *));
int nfsx_pathconf __P((struct vop_pathconf_args *));
int nfsx_advlock __P((struct vop_advlock_args *));
int nfsx_print __P((struct vop_print_args *));
int nfsx_blkatoff __P((struct vop_blkatoff_args *));
int nfsx_valloc __P((struct vop_valloc_args *));
int nfsx_vfree __P((struct vop_vfree_args *));
int nfsx_truncate __P((struct vop_truncate_args *));
int nfsx_update __P((struct vop_update_args *));
int nfsx_ioctl __P((struct vop_ioctl_args *));
int nfsx_select __P((struct vop_select_args *));
int nfsx_pagein __P((struct vop_pagein_args *));
int nfsx_pageout __P((struct vop_pageout_args *));
int nfsx_blktooff __P((struct vop_blktooff_args *));
int nfsx_offtoblk __P((struct vop_offtoblk_args *));
int nfsx_cmap __P((struct vop_cmap_args *));
int nfsx_bmap __P((struct vop_bmap_args *));
int nfsx_lookup  __P((struct vop_lookup_args *));
int nfsx_write __P((struct vop_write_args *));


#endif /* _NFSX_VNOPS_H */
