/*
 * xdr.c
 *
 * Copyright (c) 2004 The Regents of the University of Michigan.
 * All rights reserved.
 *
 * Copyright (c) 2004 Marius Aamodt Eriksen <marius@umich.edu>.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the University nor the names of its
 *    contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
 * BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * $Id: xdr.c,v 1.3 2004/06/14 19:38:56 marius Exp $
 */

#include <sys/types.h>
#include <sys/queue.h>
#include <sys/tree.h>
#include <sys/param.h>

#include <rpc/rpc.h>
#include <rpc/xdr.h>

#include <rpcx/rpcclnt_redirect.h>

#include <stdlib.h>
#include <stdio.h>
#include <err.h>

#include "rpcd.h"

void log_hexdump(const u_char *, int, int);

/*
 * Note that xdr_getsize() is not a standard XDR function; it's
 * integrated only into the bundled version of Sun ONC RPC.
 */

bool_t
xdr_req(XDR *xdrs, struct rpcclnt_redirect_req *req)
{
#ifdef DEBUG
	fprintf(stderr, "in xdr_req()\n");
	fprintf(stderr, "RPC request (%p/%d):\n", req->req_bp, req->req_len);
	log_hexdump(req->req_bp, req->req_len, 0);
#endif
	return (xdr_opaque(xdrs, req->req_bp, req->req_len));
}

bool_t
xdr_rep(XDR *xdrs, struct rpcclnt_redirect_rep *rep)
{
	size_t len = xdr_getsize(xdrs);
	bool_t success;

#ifdef DEBUG
	fprintf(stderr, "in xdr_rep()\n");
#endif

	if ((rep->rep_bp = malloc(len)) == NULL)
		return (FALSE);

	rep->rep_len = len;

	success = xdr_opaque(xdrs, rep->rep_bp, rep->rep_len);

#ifdef DEBUG
	if (success) {
		fprintf(stderr, "RPC reply (%p/%d):\n",
		    rep->rep_bp, rep->rep_len);
		log_hexdump(rep->rep_bp, rep->rep_len, 0);
	} else
		fprintf(stderr, "RPC reply error\n");

	if (!success)
		fprintf(stderr, "Opaque decoding failed\n");
#endif

	return (success);
}
