/*
 * rpcd.h
 *
 * Copyright (c) 2004 The Regents of the University of Michigan.
 * All rights reserved.
 *
 * Copyright (c) 2004 Marius Aamodt Eriksen <marius@umich.edu>.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the University nor the names of its
 *    contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
 * BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * $Id: rpcd.h,v 1.4 2004/06/10 19:17:49 marius Exp $
 */

#ifndef _RPCD_H
#define _RPCD_H

#define DEV_RPCD "/dev/rpcd"

struct rpcd_ctx {
	SPLAY_ENTRY(rpcd_ctx) ctx_node;

	CLIENT *ctx_clnt;
	uid_t   ctx_uid;
	char    ctx_svc_export[128 + MAXPATHLEN]; /* arbitrary */
	char    ctx_mntpt[MAXPATHLEN];

	char   *ctx_host;
};

int set_krb5_ccache(uid_t);

void             ctx_put(struct rpcd_ctx *);
struct rpcd_ctx *ctx_get(uid_t, char *, char *);
void             ctx_init(void);
int              ctx_refresh(struct rpcd_ctx *);


bool_t xdr_req(XDR *, struct rpcclnt_redirect_req *);
bool_t xdr_rep(XDR *, struct rpcclnt_redirect_rep *);

#endif /* _RPCD_H */
