/*
 * Sun RPC is a product of Sun Microsystems, Inc. and is provided for
 * unrestricted use provided that this legend is included on all tape
 * media and as a part of the software program in whole or part.  Users
 * may copy or modify Sun RPC without charge, but are not authorized
 * to license or distribute it to anyone else except as part of a product or
 * program developed by the user.
 * 
 * SUN RPC IS PROVIDED AS IS WITH NO WARRANTIES OF ANY KIND INCLUDING THE
 * WARRANTIES OF DESIGN, MERCHANTIBILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE, OR ARISING FROM A COURSE OF DEALING, USAGE OR TRADE PRACTICE.
 * 
 * Sun RPC is provided with no support and without any obligation on the
 * part of Sun Microsystems, Inc. to assist in its use, correction,
 * modification or enhancement.
 * 
 * SUN MICROSYSTEMS, INC. SHALL HAVE NO LIABILITY WITH RESPECT TO THE
 * INFRINGEMENT OF COPYRIGHTS, TRADE SECRETS OR ANY PATENTS BY SUN RPC
 * OR ANY PART THEREOF.
 * 
 * In no event will Sun Microsystems, Inc. be liable for any lost revenue
 * or profits or other special, indirect and consequential damages, even if
 * Sun has been advised of the possibility of such damages.
 * 
 * Sun Microsystems, Inc.
 * 2550 Garcia Avenue
 * Mountain View, California  94043
 */

#if defined(LIBC_SCCS) && !defined(lint)
static char *rcsid = "$OpenBSD: bindresvport.c,v 1.9 1996/09/15 09:31:30 tholo Exp $";
#endif /* LIBC_SCCS and not lint */

/*
 * Copyright (c) 1987 by Sun Microsystems, Inc.
 *
 * Portions Copyright(C) 1996, Jason Downs.  All rights reserved.
 */

#include <string.h>
#include <sys/types.h>
#include <sys/errno.h>
#include <sys/socket.h>
#include <netinet/in.h>

/*
 * Bind a socket to a privileged IP port
 */
#ifdef __linux__
#include <unistd.h>

/* Old cruft. */
int
bindresvport(sd, sin)
	int sd;
	struct sockaddr_in *sin;
{
	int res;
	static short port;
	struct sockaddr_in myaddr;
#ifndef errno
	extern int errno;
#endif
	int i;

#define STARTPORT 600
#define ENDPORT (IPPORT_RESERVED - 1)
#define NPORTS	(ENDPORT - STARTPORT + 1)

	if (sin == (struct sockaddr_in *)0) {
		sin = &myaddr;
		bzero(sin, sizeof (*sin));
		sin->sin_family = AF_INET;
	} else if (sin->sin_family != AF_INET) {
		errno = EPFNOSUPPORT;
		return (-1);
	}
	if (port == 0) {
		port = (getpid() % NPORTS) + STARTPORT;
	}
	res = -1;
	errno = EADDRINUSE;
	for (i = 0; i < NPORTS && res < 0 && errno == EADDRINUSE; i++) {
		sin->sin_port = htons(port++);
		if (port > ENDPORT) {
			port = STARTPORT;
		}
		res = bind(sd, sin, sizeof(struct sockaddr_in));
	}
	return (res);
}
#else
int
bindresvport(sd, sin)
	int sd;
	struct sockaddr_in *sin;
{
	int on, old, error;
	struct sockaddr_in myaddr;
	int sinlen = sizeof(struct sockaddr_in);

	if (sin == (struct sockaddr_in *)0) {
		sin = &myaddr;
		memset(sin, 0, sinlen);
		sin->sin_len = sinlen;
		sin->sin_family = AF_INET;
	} else if (sin->sin_family != AF_INET) {
		errno = EPFNOSUPPORT;
		return (-1);
	}

	if (sin->sin_port == 0) {
		int oldlen = sizeof(old);
		error = getsockopt(sd, IPPROTO_IP, IP_PORTRANGE,
				   &old, &oldlen);
		if (error < 0)
			return(error);

		on = IP_PORTRANGE_LOW;
		error = setsockopt(sd, IPPROTO_IP, IP_PORTRANGE,
		           	   &on, sizeof(on));
		if (error < 0)
			return(error);
	}

	error = bind(sd, (struct sockaddr *)sin, sinlen);

	if (sin->sin_port == 0) {
		int saved_errno = errno;

		if (error) {
			if (setsockopt(sd, IPPROTO_IP, IP_PORTRANGE,
			    &old, sizeof(old)) < 0)
				errno = saved_errno;
			return (error);
		}

		if (sin != &myaddr) {
			/* Hmm, what did the kernel assign... */
			if (getsockname(sd, (struct sockaddr *)sin,
			    &sinlen) < 0)
				errno = saved_errno;
			return (error);
		}
	}
	return (error);
}
#endif /* __linux__ */
