/* $FreeBSD$ */
/* $Id: rpc_dev.h,v 1.6 2004/06/14 19:38:56 marius Exp $ */

/*
 * copyright (c) 2003
 * the regents of the university of michigan
 * all rights reserved
 * 
 * permission is granted to use, copy, create derivative works and redistribute
 * this software and such derivative works for any purpose, so long as the name
 * of the university of michigan is not used in any advertising or publicity
 * pertaining to the use or distribution of this software without specific,
 * written prior authorization.  if the above copyright notice or any other
 * identification of the university of michigan is included in any copy of any
 * portion of this software, then the disclaimer below must also be included.
 * 
 * this software is provided as is, without representation from the university
 * of michigan as to its fitness for any purpose, and without warranty by the
 * university of michigan of any kind, either express or implied, including
 * without limitation the implied warranties of merchantability and fitness for
 * a particular purpose. the regents of the university of michigan shall not be
 * liable for any damages, including special, indirect, incidental, or
 * consequential damages, with respect to any claim arising out of or in
 * connection with the use of the software, even if it has been or is hereafter
 * advised of the possibility of such damages.
 */

#ifndef _RPC_DEV_H_
#define _RPC_DEV_H

#include <sys/ioccom.h>


/* type of upcall */
#define RPCDEV_TYPE_IDMAP 0
#define RPCDEV_TYPE_RPCD   1
#define RPCDEV_MAX_TYPE   1

struct rpcdev_msg {
	unsigned int msg_vers;
	unsigned int msg_type;
	unsigned int msg_xid;
	unsigned int msg_error;

	size_t msg_len;
	caddr_t msg_data;
};

#define RPCDEV_VERSION  (0x4 << 16 | sizeof(struct rpcdev_msg))

/* ioctl commands */
#define RPCDEVIOCGET _IOWR('A', 0x200, struct rpcdev_msg)
#define RPCDEVIOCPUT _IOW('A', 0x201, struct rpcdev_msg)

#ifdef _KERNEL
int  rpcdev_call(uint32_t, caddr_t, size_t, caddr_t, size_t *, int);

void rpcdev_wakeup(int);

cthread_t *rpcdev_gethandlertd(uint32_t);
int        rpcdev_puthandlertd(uint32_t);

void rpcdev_purge(void);

void rpcdev_init(void);
void rpcdev_uninit(void);
#endif

#endif /* _RPC_DEV_H_ */
