#!/usr/bin/perl

# This should match the machine the measurements were taken on 
$ghz = .933;

# open /proc/rpc_profile
open PROC, "/proc/kprofile_totals";

# Get results
while ($line = <PROC>)
{
	if ($line =~ /(.+)\t(.+)\t(\d+)\t(\d+)\t(\d+):(\d+)\t(\d+):(\d+)\t(\d+):(\d+)\t(\d+)/)
	{
		$test = $1;
		$proc = $2;
		$count = $3;
		$discarded = $4;
		$avg = $6;
		$low = $8;
		$high = $10;

		# Convert times to nanoseconds
		$avg = int ($avg * $ghz);
		$low = int ($low * $ghz);
		$high = int ($high * $ghz);

		$reverse{$proc}{$test} = "whatever";

		$avgs{$test}{$proc} = $avg;
		$counts{$test}{$proc} = $count;
		$discardeds{$test}{$proc} = $discarded;
		$lows{$test}{$proc} = $low;
		$highs{$test}{$proc} = $high;
	}
}

# Produce a table for each rpc
foreach $proc (sort keys %reverse)
{
	# Headings
	print "<h2>$proc</h2>\n";
	print "<table border='1'>\n";
	print "\t<tr>\n";
	print "\t\t<td>&nbsp;</td>\n";
	print "\t\t<th>Count</th>\n";
	print "\t\t<th>Discarded</th>\n";
	print "\t\t<th>Avg (ns)</th>\n";
	print "\t\t<th>Low (ns)</th>\n";
	print "\t\t<th>High (ns)</th>\n";
	print "\t\t<th>Total time (ms)</th>\n";
	print "\t</tr>\n";

	# Produce a row for each test
	foreach $test (sort keys %avgs)
	{
		$total_time = int($counts{$test}{$proc} * $avgs{$test}{$proc} / 1e6);
		print "\t<tr>\n";
		print "\t\t<th>$test</th>\n";
		print "\t\t<td>$counts{$test}{$proc}</td>\n";
		print "\t\t<td>$discardeds{$test}{$proc}</td>\n";
		print "\t\t<td>$avgs{$test}{$proc}</td>\n";
		print "\t\t<td>$lows{$test}{$proc}</td>\n";
		print "\t\t<td>$highs{$test}{$proc}</td>\n";
		print "\t\t<td>$total_time</td>\n";
		print "\t</tr>\n";
	}

	# end the table
	print "</table>\n";
}
