/* linux bandwidth monitor 0.2.2
   coded by 32x 2001, fredde@linux.se
   http://www.32x.f2s.com

   Linux bandwidth monitor, monitor your bandwidth

   Compile str, gcc bmon.c -o bmon -lncurses
   Usage info ./bmon -h or read README for more info

   Modified by Steve Molloy <smolloy@umich.edu> on May 7, 2001
   to support non-cursor-based output which is more useful for
   logging during benchmarks.  This behavior allows bmon to
   behave like vmstat with regards to output.  I also fixed a
   bug in the argument parsing and added basic signal handling.
*/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <curses.h>
#include <signal.h>

#define DEVFILE "/proc/net/dev"
#define UPTFILE "/proc/uptime"

#define VERSION "0.2.2"

char data_rc[256], data_tr[256], data_to[256];
int alive;

struct dev_info 
{
	char interface[20];
	unsigned long int rc_byte;
	unsigned long int rc_byte_old;

	unsigned long int tr_byte;
	unsigned long int tr_byte_old;

	unsigned long int rc_pkg;
	unsigned long int rc_pkg_old;

	unsigned long int tr_pkg;
	unsigned long int tr_pkg_old;

	unsigned long int rc_total;
	unsigned long int tr_total;

	struct field_info { char value[1024]; };
	struct field_info field[16];
};

int usage(char *argv[])
{
	printf("Bandwidth Monitor %s, coded by 32x fredde@linux.se\n", VERSION);
	printf("Usage %s <option>\n", argv[0]);
	printf("Options\n");
	printf("-d \t\t - Ignore dummy interfaces\n");
	printf("-m <ifc_string>\t - Only show interfaces that matches <ifc_string>\n");
	printf("-i <ifc_string>\t - Ignore interfaces that matches <ifc_string>\n");
	printf("-u <int_interval>- Update frequency in seconds (default 1)\n");
	printf("-a \t\t - Show amount of data transfered on each interface\n");
	printf("-l \t\t - Stream data for logging instead of using a refreshing display\n");
	printf("-p \t\t - Show package status\n");
	printf("-v \t\t - Show average bandwidth usage since boot\n");
	printf("-t \t\t - Show uptime which data reflects on\n");
	printf("-f \t\t - Display friendly field description\n\n");

	exit(0);
	return 0;
}


void die_peacefully(int signum)
{
	alive = 0;
}

int main(int argc, char *argv[])
{
	struct dev_info dev[20];
	char buffer[1024], buffercpy[1024], miface[10], iiface[10];

	FILE *file;

	unsigned int i, x, j, num = 1, fieldnum, check = 0, sleep_time = 1, carg = 1, got_info = 0, tmp;
	unsigned int rc_pkg, tr_pkg, total_pkg;
	unsigned int val_dummy = 0, val_match = 0, val_package = 0, val_amount = 0, show = 1;
	unsigned int val_average = 0, val_uptime = 0, val_desc = 0, val_ignore = 0, val_logmode = 0;
	unsigned int day, hour, min, sec, uptime;

	float rc_speed, tr_speed, total_speed;
	float rc_average, tr_average, total_average;
	float uptime_one, uptime_two;

	if (argc > 0)
	{
		while((i = getopt(argc, argv, "d,m:,i:,u:,a,l,p,v,t,f,h")) != -1)
		{
			carg++;
			switch(i)
			{
				case 'd': { val_dummy = 1; break; }
				case 'm': { val_match = 1; strncpy(miface,argv[carg++],sizeof(miface)); break; }
				case 'i': { val_ignore = 1; strncpy(iiface,argv[carg++],sizeof(iiface)); break; }
				case 'u': { sleep_time = atoi(argv[carg++]); break; }
				case 'a': { val_amount = 1; break; }
				case 'l': { val_logmode = 1; break; }
				case 'p': { val_package = 1; break; }
				case 'v': { val_average = 1; break; }
				case 't': { val_uptime = 1; break; }
				case 'f': { val_desc = 1; break; }
				case 'h': { usage(argv); break; }
				default: { usage(argv); }
			}
		}
	}
	printf("Linux Bandwidth Monitor %s coded by 32x 2001, fredde@linux.se\n", VERSION);
	printf("http://www.32x.f2s.com\n\n");

	/* Basic signal handling so we can quit nicely and not lose data when redirecting output */
	alive = 1;
	signal(SIGHUP, (void *)die_peacefully);
	signal(SIGINT, (void *)die_peacefully);
	signal(SIGQUIT, (void *)die_peacefully);

	if (val_logmode)
	{
		printf("Interface      Receive             Transmit            Total\n");
		if (val_desc == 1) { printw("Type           "); }
		printf("\n");
	}
	else
	{
		initscr(); halfdelay(1); noecho();
		clear();
		move(0,0);
		attron(A_BOLD);
		printw("Linux Bandwidth Monitor\n");
		attroff(A_BOLD);
		attron(A_STANDOUT);
		printw("Interface      Receive             Transmit            Total         ");
		if (val_desc == 1) { printw("Type           "); }
		attroff(A_STANDOUT);
	}

	while(alive)
	{
		num = 1; check = 0;
		if ((file = fopen(DEVFILE, "r")) != NULL)
		{
			while((fgets(buffer,sizeof(buffer),file) != NULL) && num <= 20)
			{
				if (strstr(buffer,":"))
				{
					strcpy(buffercpy, buffer);
					strtok(buffercpy, ":");				
					strcpy(dev[num].interface, buffercpy);
					fieldnum = 1; x = 0; check = 0;

					for (i = strlen(buffercpy)+1; i <= strlen(buffer); i++)
					{
						if ((buffer[i] != 32) && (check == 0)) { check = 1; x = 0; }
						else if ((buffer[i] == 32) && (check == 1)) { check = 0; fieldnum++; }
						if ((buffer[i] != 32) && (check == 1)) { dev[num].field[fieldnum].value[x] = buffer[i]; x++; }
					}
					dev[num].rc_byte = strtoul(dev[num].field[1].value,NULL,10);
					dev[num].rc_pkg = strtol(dev[num].field[2].value,NULL,10);
					dev[num].tr_byte = strtoul(dev[num].field[9].value,NULL,10);
					dev[num].tr_pkg = strtoul(dev[num].field[10].value,NULL,10);
			
					if (got_info == 0)
					{
						dev[num].rc_total = dev[num].rc_byte;
						dev[num].tr_total = dev[num].tr_byte;	
					}
					else 
					{
						dev[num].rc_total = dev[num].rc_total + (float) ((dev[num].rc_byte - dev[num].rc_byte_old) / sleep_time);
						dev[num].tr_total = dev[num].tr_total + (float) ((dev[num].tr_byte - dev[num].tr_byte_old) / sleep_time);
					}
					num++;
				}
			}
			fclose(file);
		}
		else
		{
			if (!val_logmode)
				endwin();
			fprintf(stderr,"Error: Could not open %s\n", DEVFILE); exit(0);
		}

		if ((file = fopen(UPTFILE, "r")) != NULL)
		{
			fscanf(file, "%f %f", &uptime_one, &uptime_two);
			fclose(file);
		}
		else
		{
			if (!val_logmode)
				endwin();
			fprintf(stderr, "Error: Could not open %s\n", UPTFILE); exit(0);
		}
		
		x = 1;
		for (i = 1; i < num; i++)
		{
			if (!val_logmode) { move(x+1,0); }
			show = 1;

			rc_speed = (float) (dev[i].rc_byte - dev[i].rc_byte_old) / sleep_time;
			tr_speed = (float) (dev[i].tr_byte - dev[i].tr_byte_old) / sleep_time;
			total_speed = (float) (rc_speed + tr_speed);
	
			rc_pkg = (dev[i].rc_pkg - dev[i].rc_pkg_old) / sleep_time;
			tr_pkg = (dev[i].tr_pkg - dev[i].tr_pkg_old) / sleep_time;
			total_pkg = (rc_pkg + tr_pkg);					

			rc_average = (float) dev[i].rc_byte / uptime_one;
			tr_average = (float) dev[i].tr_byte / uptime_one;
			total_average = (float) (rc_average + tr_average);

			if ((val_dummy == 1) && (strstr(dev[i].interface,"dummy"))) { show = 0; }
			else if ((val_match == 1) && (!strstr(dev[i].interface,miface))) { show = 0; }
			if ((val_ignore == 1) && (strstr(dev[i].interface,iiface))) { show = 0; }
			if (got_info == 0) { show = 0; }

			if ((show == 1) && (val_logmode == 0))
			{
				printw("%9s %10.3f KB/sec %12.3f KB/sec %12.3f KB/sec", dev[i].interface, rc_speed/1024, tr_speed/1024, total_speed / 1024);	
				if (val_desc == 1) { printw("  (bytes/sec)"); }
				printw("\n");
				if (val_package == 1) 
				{ 
					printw("%20d PKG/sec %11d PKG/sec %12d PKG/sec", rc_pkg, tr_pkg, total_pkg); x++; 
					if (val_desc == 1) { printw(" (packages/sec)"); }
					printw("\n");
				}
				if (val_average == 1) 
				{ 
					printw("%20.3f KB/sec %12.3f KB/sec %12.3f KB/sec", rc_average/1024, tr_average/1024, total_average/1024); x++; 
					if (val_desc == 1) { printw("  (average usage)"); }
					printw("\n");
				}
				if (val_amount == 1) 
				{
					makedots(dev[i].rc_total / 1024, dev[i].tr_total / 1024, (dev[i].rc_total + dev[i].tr_total) / 1024);
					printw("%20s KB %16s KB %16s KB", data_rc, data_tr, data_to); x++; 					
					if (val_desc == 1) { printw("      (amount data)"); }
					printw("\n");
				}
				x+=2;
			}
			else if (show == 1)
			{
				printf("%9s %10.3f KB/sec %12.3f KB/sec %12.3f KB/sec", dev[i].interface, rc_speed/1024, tr_speed/1024, total_speed / 1024);	
				if (val_desc == 1) { printf("  (bytes/sec)"); }
				printf("\n");
				if (val_package == 1) 
				{ 
					printf("%20d PKG/sec %11d PKG/sec %12d PKG/sec", rc_pkg, tr_pkg, total_pkg); x++; 
					if (val_desc == 1) { printf(" (packages/sec)"); }
					printf("\n");
				}
				if (val_average == 1) 
				{ 
					printf("%20.3f KB/sec %12.3f KB/sec %12.3f KB/sec", rc_average/1024, tr_average/1024, total_average/1024); x++; 
					if (val_desc == 1) { printf("  (average usage)"); }
					printf("\n");
				}
				if (val_amount == 1) 
				{
					makedots(dev[i].rc_total / 1024, dev[i].tr_total / 1024, (dev[i].rc_total + dev[i].tr_total) / 1024);
					printf("%20s KB %16s KB %16s KB", data_rc, data_tr, data_to); x++; 					
					if (val_desc == 1) { printf("      (amount data)"); }
					printf("\n");
				}
			}


			dev[i].rc_byte_old = dev[i].rc_byte;
			dev[i].tr_byte_old = dev[i].tr_byte;
			dev[i].rc_pkg_old = dev[i].rc_pkg;
			dev[i].tr_pkg_old = dev[i].tr_pkg;
				
			if (!val_logmode)
				refresh();
		}

		uptime = uptime_one;
		sec = uptime%60;
		uptime = (uptime - sec) / 60;
		min = uptime % 60;
		uptime = (uptime - min) / 60;
		hour = uptime % 24;
		uptime = (uptime - hour) / 24;
		day = uptime % 7;

		if ((val_uptime == 1) && (got_info == 1))
		{
			if (val_logmode)
				printf("Data reflects %d days %2.2d hours %2.2d min %2.2d sec of system uptime\n", day, hour, min, sec);
			else
				printw("Data reflects %d days %2.2d hours %2.2d min %2.2d sec of system uptime\n", day, hour, min, sec);
		}
		if ((got_info == 0) && (!val_logmode))
		{
			move(2,0); refresh();
			printw("Loading, please wait...");
		}

		if (!val_logmode)
		{
			x++;
			move(x+1,0); refresh();
			if (getch() == 27) { break; }
		}
		got_info = 1;
		sleep(sleep_time);
	}
	if (!val_logmode)
		endwin();
	return 0;
}

int makedots(int rc_value, int tr_value, int to_value)
{
	int i, j, x;
	char buffer[256];
	char tmp[256];
	char string[256];

	sprintf(data_rc, "");
	sprintf(data_tr, "");
	sprintf(data_to, "");

	sprintf(tmp, "%d", rc_value);
	sprintf(buffer, "");

	for (i = strlen(tmp); i >= 0; i--)
	{
		sprintf(buffer,"%s%c", buffer, tmp[i]);
		j++;
		if (j == 4) { sprintf(buffer,"%s ", buffer); j = 1; }
		x++;
	}
	j = 0;
	for (i = strlen(buffer); i >= 0; i--)
	{
		if (((buffer[i] == ' ') && (i != strlen(buffer)-1)) || (buffer[i] != ' ')) { sprintf(data_rc,"%s%c", data_rc, buffer[i]); }
	}

        sprintf(tmp, "%d", tr_value);
        sprintf(buffer, ""); 
                
        for (i = strlen(tmp); i >= 0; i--)
        {
                sprintf(buffer,"%s%c", buffer, tmp[i]);
                j++;
                if (j == 4) { sprintf(buffer,"%s ", buffer); j = 1; }
                x++;
        }
        j = 0;
        for (i = strlen(buffer); i >= 0; i--)
        {
                if (((buffer[i] == ' ') && (i != strlen(buffer)-1)) || (buffer[i] != ' ')) { sprintf(data_tr,"%s%c", data_tr, buffer[i]); }
        }

        sprintf(tmp, "%d", to_value);
        sprintf(buffer, "");
        
        for (i = strlen(tmp); i >= 0; i--)
        {
                sprintf(buffer,"%s%c", buffer, tmp[i]);
                j++;
                if (j == 4) { sprintf(buffer,"%s ", buffer); j = 1; }
                x++;
        }
        j = 0;
        for (i = strlen(buffer); i >= 0; i--)
        {
                if (((buffer[i] == ' ') && (i != strlen(buffer)-1)) || (buffer[i] != ' ')) { sprintf(data_to,"%s%c", data_to, buffer[i]); }
        }


}

