Summary: Utilities for monitoring your system and processes on your system.
Name: procps
%define version 1.2.11
Version: %{version}
Release: 1
Copyright: GPL
Group: System Environment/Base
Source: ftp://tsx-11.mit.edu/pub/linux/sources/usr.bin/procps-%{version}.tar.gz
BuildRoot: /var/tmp/procps-root

%package X11
Group: Applications/System
Summary: X based process monitoring utilities.

%description
The procps package contains a set of system utilities which provide
system information.  Procps includes ps, free, sessreg, skill, snice,
tload, top, uptime, vmstat, w, and watch.  The ps command displays
a snapshot of running processes.  The top command provides a
repetitive update of the statuses of running processes.  The free
command displays the amounts of free and used memory on your system.
Sessreg is a simple program for managing utmp/wtmp entries for xdm
sessions.  The skill command sends a terminate command (or another
specified signal) to a specified set of processes.  The snice
command is used to change the scheduling priority of specified
processes.  The tload command prints a graph of the current system
load average to a specified tty.  The uptime command displays the
current time, how long the system has been running, how many users
are logged on and system load averages for the past one, five and
fifteen minutes.  The w command displays a list of the users who
are currently logged on and what they're running.  The watch program
watches a running program.  The vmstat command displays virtual
memory statistics about processes, memory, paging, block I/O, traps
and CPU activity.

%description X11
The procps-X11 package contains X Window System utilities for monitoring
your system.  The utilities contained in this package generally provide
graphical representations of the information provided by the tools in
the procps package.

Install the procps-X11 package if you'd like to use a graphical
system monitoring utility.

%prep
%setup

%build
PATH=/usr/X11R6/bin:$PATH

make CC="gcc $RPM_OPT_FLAGS" LDFLAGS=-s

%install
rm -rf $RPM_BUILD_ROOT
mkdir -p $RPM_BUILD_ROOT/bin $RPM_BUILD_ROOT/usr/bin $RPM_BUILD_ROOT/usr/sbin
mkdir -p $RPM_BUILD_ROOT/usr/man/man1 $RPM_BUILD_ROOT/usr/man/man8
mkdir -p $RPM_BUILD_ROOT/lib

make DESTDIR=$RPM_BUILD_ROOT install

# Since this is specific to Red Hat now, we'll leave this in the spec file.
# If others decide they like wmconfig, we'll move it to the install phase
# of the Makefile.
mkdir -p $RPM_BUILD_ROOT/etc/X11/wmconfig
install -m 644 top.wmconfig $RPM_BUILD_ROOT/etc/X11/wmconfig/top

%clean
rm -rf $RPM_BUILD_ROOT

%post
# add libproc to the cache
/sbin/ldconfig
# ask ps to set up /etc/psdevtab if /proc is mounted
if [ -f /proc/uptime ] ; then
  /bin/ps </dev/null >/dev/null 2>&1
fi
# having this file around will cause ps to complain, since it
# does not get updated.
rm -f /etc/psdatabase

%files
%attr(0644,root,root) %config(missingok) /etc/X11/wmconfig/top
%attr(0644,root,root) %doc NEWS BUGS TODO
%attr(755,root,root) /lib/libproc.so.1.2.6
%attr(555,root,root) /bin/ps
%attr(555,root,root) /usr/bin/uptime
%attr(555,root,root) /usr/bin/tload
%attr(555,root,root) /usr/bin/free
%attr(555,root,root) /usr/bin/w
%attr(555,root,root) /usr/bin/top
%attr(555,root,root) /usr/bin/vmstat
%attr(555,root,root) /usr/bin/sessreg
%attr(555,root,root) /usr/bin/watch
%attr(555,root,root) /usr/bin/skill
%attr(555,root,root) /usr/bin/snice

%attr(0644,root,root) /usr/man/man1/free.1
%attr(0644,root,root) /usr/man/man1/ps.1
%attr(0644,root,root) /usr/man/man1/sessreg.1
%attr(0644,root,root) /usr/man/man1/skill.1
%attr(0644,root,root) /usr/man/man1/snice.1
%attr(0644,root,root) /usr/man/man1/tload.1
%attr(0644,root,root) /usr/man/man1/top.1
%attr(0644,root,root) /usr/man/man1/uptime.1
%attr(0644,root,root) /usr/man/man1/w.1
%attr(0644,root,root) /usr/man/man1/watch.1
%attr(0644,root,root) /usr/man/man8/vmstat.8

%files X11
%attr(4755,root,root) /usr/X11R6/bin/XConsole
