/*
 * $Id: bench.h,v 1.22 1997/10/20 06:44:34 lm Exp $
 */
#ifndef _BENCH_H
#define _BENCH_H

#include        <ctype.h>
#include        <stdio.h>
#include        <unistd.h>
#include        <stdlib.h>
#include        <fcntl.h>
#include        <signal.h>
#include        <errno.h>
#include        <strings.h>
#include        <sys/types.h>
#include        <sys/mman.h>
#include        <sys/stat.h>
#include        <sys/wait.h>
#include        <sys/time.h>
#include        <sys/socket.h>
#include        <sys/un.h>
#include        <sys/resource.h>
#include	<rpc/rpc.h>
#include	"stats.h"
#include	"timing.h"
#include	"lib_tcp.h"
#include	"lib_udp.h"

#ifdef	NO_PORTMAPPER	/* not recently tested */
#define	TCP_XACT	-3962
#define	TCP_CONTROL	-3963
#define	TCP_DATA	-3964
#define	TCP_CONNECT	-3965
#else
#define	TCP_XACT	(u_long)404039	/* XXX - unregistered */
#define	TCP_CONTROL	(u_long)404040	/* XXX - unregistered */
#define	TCP_DATA	(u_long)404041	/* XXX - unregistered */
#define	TCP_CONNECT	(u_long)404042	/* XXX - unregistered */
#define	UDP_XACT 	(u_long)404032	/* XXX - unregistered */
#define	UDP_DATA 	(u_long)404033	/* XXX - unregistered */
#define	VERS		(u_long)1
#endif

#define	UNIX_CONTROL	"/tmp/lmbench.ctl"
#define	UNIX_DATA	"/tmp/lmbench.data"
#define	UNIX_LAT	"/tmp/lmbench.lat"

/*
 * socket send/recv buffer optimizations
 */
#define	SOCKOPT_READ	0x0001
#define	SOCKOPT_WRITE	0x0002
#define	SOCKOPT_RDWR	0x0003
#define	SOCKOPT_PID	0x0004
#define	SOCKOPT_REUSE	0x0008
#define	SOCKOPT_NONE	0

#ifndef SOCKBUF
#define	SOCKBUF		(1024*1024)
#endif

#ifndef	XFERSIZE
#define	XFERSIZE	(64*1024)	/* all bandwidth I/O should use this */
#endif

#ifdef SYS5
#define	bzero(b, len)	memset(b, 0, len)
#define	bcopy(s, d, l)	memcpy(d, s, l)
#define	rindex(s, c)	strrchr(s, c)
#endif
#define	gettime		usecs_spent
#define	streq		!strcmp
#define	ulong		unsigned long

#define	SMALLEST_LINE	32		/* smallest cache line size */
#define	TIME_OPEN2CLOSE

#define	GO_AWAY	signal(SIGALRM, exit); alarm(60 * 60);
#define	REAL_SHORT	   50000
#define	SHORT	 	 1000000
#define	MEDIUM	 	 2000000
#define	LONGER		 7500000	/* for networking data transfers */
#define	ENOUGH		REAL_SHORT

#define	TRIES		11

typedef struct {
	uint64	u;
	uint64	n;
} result_t;
void    insertinit(result_t *r, int n);
void    insertsort(uint64, uint64, result_t *, int);

#define	BENCHO(loop_body, overhead_body, enough)  			\
	{ double __oh;							\
	BENCH(overhead_body, enough);					\
	__oh = gettime();						\
	__oh /= get_n();						\
	BENCH(loop_body, enough);					\
	settime((uint64)(gettime() - (get_n() * __oh)));		\
	}

#define	BENCH(loop_body, enough)  					\
	if (enough == 0 || get_enough(enough) <= 100000) {		\
		result_t r[TRIES];					\
		int	i;						\
		uint64	u;						\
		double	tmp;						\
		insertinit(r, TRIES);					\
		loop_body;			/* warm the cache */	\
		for (i = 0; i < TRIES; ++i) {				\
			BENCH1(loop_body, enough);			\
			tmp = l_overhead();  tmp *= (double)get_n();	\
			u = usecs_spent() - (uint64)tmp;		\
			insertsort(u, get_n(), r, TRIES);		\
		}							\
		save_n(r[TRIES/2].n); settime(r[TRIES/2].u);		\
	} else {							\
		if (enough < LONGER) {loop_body;} /* warm the cache */	\
		BENCH1(loop_body, enough);				\
	}								\


#define	BENCH1(loop_body, enough) { 					\
	static long	__iterations = 1;				\
	long		__n;						\
	double		__result;					\
	int		__enough = get_enough(enough);			\
									\
	for (;;) {							\
	start(0);							\
	for (__n = __iterations; __n > 0; __n--) {			\
		loop_body;						\
	}								\
	__result = stop(0,0);						\
	/* printf("u=%.0f n=%d\n", __result,__iterations); 		\
	*/								\
	save_n((uint64)__iterations);					\
	__result -= t_overhead();					\
	if (__result < 0.99 * __enough || __result > 1.2 * __enough) {	\
		if (__result > 150) {					\
			double	tmp = __iterations / __result;		\
			tmp *= 1.1 * __enough;				\
			__iterations = (long)(tmp + 1);			\
		} else							\
			__iterations *= 10;				\
	}								\
	if (__result >= 0.95 * __enough) 				\
		break;							\
	} /* for */							\
	settime((uint64)(usecs_spent() - t_overhead()));		\
}

#if 0
	/*  \
	   fprintf(stderr, "\tN=%d u=%lu", __interations, (unsigned long)usecs);	\
	   fflush(stderr);\
	   fprintf(stderr, " c=%.2f\tr=%.2f\n", (double)usecs/__interations,	\
		((double)usecs - t_overhead - __interations * l_overhead)		\
		/ __interations );  			\
	*/ \
#endif

/*
 * Standard timing loop.  Usage:
 *
 *	LOOP_FIRST(N, usecs, time)
 *	<code that you want timed>
 *	LOOP_LAST(N, usecs, time)
 *
 * time is how long you think it should run to be accurate.
 * "N" is a variable that will be set to the number of times it 
 * took to get "usecs" duration.  You then use N & usecs to print
 * out your results.
 * 
 * Notes: 
 *
 * Adjust the amount of time proportional to how
 * far we need to go.  We want time/usecs to be ~1.
 *
 * For systems with low resolution clocks, usecs can
 * be 0 or very close to 0.  We don't know how 
 * much time we spent, it could be anywhere from
 * 1 to 9999 usecs.  We pretend it was 1000 usecs.
 * The 129 value is because some systems bump the
 * timeval each time you call gettimeofday().
 */
#define	LOOP_FIRST(N, usecs, time)			\
	N = 0;						\
	do {						\
		if (!N) {				\
			N = 1;				\
		} else {				\
			double	__adj;			\
			int	__n;			\
			if (usecs <= 129) {		\
				usecs = 1000;		\
			}				\
			__adj = (int)((time * 1.5)/usecs + .9);	\
			__n = N * __adj;			\
			/* printf("\tN=%.2f u=%.2f a=%.2f n=%d\n", \
			    (double)N, (double)usecs, __adj, __n);  \
			*/ \
			N = __n <= N ? N+1 : __n;	\
		}					\
timit:		usecs = N;				\
		start(0);				\
		while (usecs--) {

#define	LOOP_LAST(N, usecs, time)			\
		}					\
		usecs = stop(0,0);			\
	} while (usecs < time);				

#define	OBENCH(test, enough, result) { 				\
	int	__bench_n, __bench_i, __bench_enough;		\
								\
	__bench_enough = get_enough(enough);			\
	test;							\
	LOOP_FIRST(__bench_n, __bench_i, __bench_enough);	\
	test;							\
	LOOP_LAST(__bench_n, __bench_i, __bench_enough);	\
	result = __bench_i;					\
	result -= t_overhead();					\
	result /= __bench_n;					\
	/*							\
	printf("usecs=%d n=%d c=%f r=%f\n", __bench_i, __bench_n, \
	    (double)__bench_i/__bench_n, result);		\
	*/							\
}


/*
 * Generated from msg.x which is included here:

	program XACT_PROG {
	    version XACT_VERS {
		char
		RPC_XACT(char) = 1;
    	} = 1;
	} = 3970;

 * Please do not edit this file.
 * It was generated using rpcgen.
 */

#include <rpc/types.h>

#define XACT_PROG ((u_long)404040)
#define XACT_VERS ((u_long)1)
#define RPC_XACT ((u_long)1)
#define RPC_EXIT ((u_long)2)
extern char *rpc_xact_1();
extern char *client_rpc_xact_1();

#endif /* _BENCH_H */
