char	*id = "$Id: seek.c,v 1.1 1996/09/05 19:32:37 lm Exp lm $\n";
/*
 * Seek - calculate seeks as a function of distance.
 *
 * Usage: seek file size [blksize [stride] ] 
 *
 * Note: caching screws this up, use a bigger blocksize than the cache.
 *
 * Copyright (c) 1994,1995,1996 Larry McVoy.  All rights reserved.
 */

#include "timing.h"
#include "bench.h"
#define	uint64	unsigned long long

main(ac, av)
	int	ac;
	char	*av[];
{
	char	*buf;
	int	bsize;
	int	disk;
	uint64	size;
	uint64	end;
	int	usecs;
	uint64	getsize(char *s);
	int	stride;

	if (ac != 3 && ac != 4 && ac != 5) {
		fprintf(stderr,
		    "Usage: %s file size [blksize [stride] ]\n", av[0]);
		exit(1);
	}
	if ((disk = open(av[1], 0)) == -1) {
		perror(av[1]);
		exit(errno);
	}
	size = getsize(av[2]);

	if (ac == 3) {
		bsize = 512;
	} else {
		bsize = getsize(av[3]);
		if (ac == 5) {
			stride = getsize(av[4]);
		} else {
			stride = 16<<20;
		}
	}

	buf = malloc(bsize);
	if (!buf) {
		perror("malloc");
		exit(errno);
	}

	end = size;
	lseek64(disk, 0, 0);
	read(disk, buf, bsize);
	while (end >= stride) {
		end -= stride;
		start();
		lseek64(disk, end, 0);
		read(disk, buf, bsize);
		usecs = stop();
		printf("%.01f %.01f\n", end / 1000000., usecs/1000.);
		lseek(disk, 0, 0);
		read(disk, buf, 512);
	}
	exit(0);
}

uint64
getsize(char *s)
{
	uint64	size = atol(s);

	switch (s[strlen(s) - 1]) {
	    case 'k':	size <<= 10;		break;
	    case 'K':	size *= 1000;		break;
	    case 'm':	size <<= 20;		break;
	    case 'M':	size *= 1000000;	break;
	    case 'g':	size <<= 30;		break;
	    case 'G':	size *= 1000000000L;	break;
	}
	return (size);
}
