/*
 * lat_proc.c - process creation tests
 *
 * Usage: lat_proc
 *
 * TODO - linux clone, plan9 rfork, IRIX sproc().
 *
 * Copyright (c) 1994 Larry McVoy.  Distributed under the FSF GPL with
 * additional restriction that results may published only if
 * (1) the benchmark is unmodified, and
 * (2) the version in the sccsid below is included in the report.
 * Support for this development by Sun Microsystems is gratefully acknowledged.
 */
char	*id = "$Id: lat_proc.c,v 1.8 1996/11/11 11:36:51 lm Exp $\n";

#include "timing.h"
#include "bench.h"
#include <abi_mutex.h>
#include <ulocks.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <sys/prctl.h>
#include <sys/sysmp.h>
#include <sys/syssgi.h>

abilock_t	a, b;

int
main(int ac, char **av)
{
	int	N = 50000, i, pid;
	void	exit();
	void	child();

	sysmp(MP_MUSTRUN, 0);
	init_lock(&a);
	init_lock(&b);
	acquire_lock(&a);
	acquire_lock(&b);

	sproc(child, PR_SALL);
	start(0);
	for (i = 0; i < N; i++) {
		release_lock(&a);
		while (acquire_lock(&b))
			sginap(0);
	}
	stop(0,0);
	micro("Sproc spinlock round trip", N);
	kill(-getpgrp(), 15);
}

/*
 * block on a and then let go b go.
 */
void
child()
{
	sysmp(MP_MUSTRUN, 1);
	for (;;) {
		while (acquire_lock(&a))
			sginap(0);
		release_lock(&b);
	}
}
