/*
 * #include "timing.h"
 * #include "bench.h"
 */
/*
 * BEGIN lib_timing.c excerpts
 */
/* don't ask --- HP-UX uglification... */
#if defined(__hpux) && !defined(_HPUX_SOURCE)
#define _HPUX_SOURCE
#endif

#define	uint64	unsigned long long

#define TRIES 9
uint64	tod_times[sizeof(uint64) * 8][TRIES];
uint64	ru_times[sizeof(uint64) * 8][TRIES];

static struct timeval start_tv, stop_tv;
static struct rusage start_ru, stop_ru;

void
tvsub(struct timeval * tdiff, struct timeval * t1, struct timeval * t0)
{
	tdiff->tv_sec = t1->tv_sec - t0->tv_sec;
	tdiff->tv_usec = t1->tv_usec - t0->tv_usec;
	if (tdiff->tv_usec < 0)
		tdiff->tv_sec--, tdiff->tv_usec += 1000000;
}

/*
 * returns the number of microseconds between begin and end
 */
uint64
tvdelta(struct timeval *begin, struct timeval *end)
{
	uint64 m;
	struct timeval tdiff;

	tvsub(&tdiff, end, begin);
	m = tdiff.tv_sec;
	m *= 1000000;
	m += tdiff.tv_usec;

	return m;
}

/*
 * Start ftiming now.
 */
void
start(struct timeval *tv)
{
	if (tv == NULL) {
		tv = &start_tv;
	}
	(void) gettimeofday(tv, (struct timezone *) 0);
	getrusage(RUSAGE_SELF, &start_ru);
}

/*
 * Stop ftiming and return real time in microseconds.
 */
uint64
stop(struct timeval *begin, struct timeval *end)
{
	if (end == NULL) {
		end = &stop_tv;
	}
	(void) gettimeofday(end, (struct timezone *) 0);
	getrusage(RUSAGE_SELF, &stop_ru);

	if (begin == NULL) {
		begin = &start_tv;
	}
	return tvdelta(begin, end);
}

/*
 * returns the CPU time this process received during the experiment
 */
void
utime_stop(struct rusage *begin_ru, struct rusage *end_ru, uint64 *result)
{
	if (begin_ru == NULL) begin_ru = &start_ru;
	if (end_ru   == NULL) end_ru   = &stop_ru;

	*result = tvdelta(&begin_ru->ru_utime, &end_ru->ru_utime);
}

#define	TYPE		long
#define	TEN(one)	one one one one one one one one one one
uint64
duration(uint64 N)
{
	TYPE	x;
	TYPE  **p;

	/* initialize the memory-resident data, so p == *p */
	x = (TYPE)&x; 
	p = (TYPE **)&x;

	start(0);
	while (N-- > 0) {
		TEN(p = (TYPE **)*p;);
	}
	return stop(0,0);
}


/*
 * END lib_timing.c excerpts
 */

void
doit(uint64 N, uint64 *t, uint64 *ru)
{
	uint64	t_t, t_ru;
	*t = duration(N);
	utime_stop(0,0, ru);
}

uint64
min_nonzero_diff(uint64 min, uint64 a, uint64 b)
{
	uint64 diff = a > b ? a - b : b - a;
	if (min == 0 || diff > 0 && diff < min) return diff;
	return min;
}

int
main()
{
	int	i, t;
	uint64	min, t_min, ru_min;

	for (i = 0; i < sizeof(uint64) * 8; ++i) {
		for (t = 0; t < TRIES; ++t) {
			doit((uint64)1 << i, &tod_times[i][t], &ru_times[i][t]);
			if (tod_times[i][t] < min || t == 0) {
				min = tod_times[i][t];
			}
		}
		if (min > 100000) break;
	}
	t_min = 0;
	ru_min = 0;
	for (;i >= 0; --i) {
		for (t = 0; t < TRIES; ++t) {
			int	u;
			for (u = t + 1; u < TRIES; u++) {
				t_min = min_nonzero_diff(t_min, tod_times[i][t], tod_times[i][u]);
				ru_min = min_nonzero_diff(ru_min, ru_times[i][t], ru_times[i][u]);
			}
			if (i > 0) {
			  for (u = 0; u < TRIES; u++) {
				t_min = min_nonzero_diff(t_min, tod_times[i][t], tod_times[i-1][u]);
				ru_min = min_nonzero_diff(ru_min, ru_times[i][t], ru_times[i-1][u]);
				t_min = min_nonzero_diff(t_min, tod_times[i][t], tod_times[i-1][u]);
				ru_min = min_nonzero_diff(ru_min, ru_times[i][t], ru_times[i-1][u]);
			  }
			}
		}
	}

	printf("gettimeofday resolution: %lu\n", (unsigned long)t_min);
	printf("getrusage resolution: %lu\n", (unsigned long)ru_min);
	exit(0);
}

