/* Intellimouse Wheel Thinger
 * VERSION 0.9.5
 * Development release
 * Copylefted under the GNU Public License
 * No code here may be used for profit without the permission of the author.
 * Author : Jonathan Atkins <jcatki@most.fw.hac.com> <jcatki@mysolution.com>
 * PLEASE: contact me if you have any improvements, I will gladly code good ones
 */
#include <stdlib.h>
#include <stdio.h>
#include <stdarg.h>
#include <string.h>
#include <getopt.h>
#include <sys/time.h>
#include <unistd.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/keysym.h>
#include <X11/extensions/XTest.h>
#include "util.h"
#include "cfg.h"
#include "imwheel.h"

#define HISTORY_LENGTH 3
#define CONFIG_TIME 4

/*----------------------------------------------------------------------------*/

Display *start(char*);
void end(Display*);
void eventLoop(Display*, char**);
void freeAllX(XClassHint*, XModifierKeymap**, char**);
int *nullXError(Display*,XErrorEvent*);

/*----------------------------------------------------------------------------*/

const struct option options[]=
{ /*{name,				has_arg,	flag,	val}*/
	{"flip-buttons",	0,			0,		'4'},
	{"wheel-fifo",		2,			0,		'W'},
	{"kill",			0,			0,		'k'},
	//{"restart",			0,			0,		'R'},
	{"detach",			0,			0,		'd'},
	{"pid",				0,			0,		'p'},
	{"Debug",			0,			0,		'D'},
	{"quit",			0,			0,		'q'},
	{"help",			0,			0,		'h'},
	{0,					0,			0,		0}
};
const char *optionusage[][2]=
{ /*{argument name,		usage}*/
	{NULL,				"Makes buttons 4 and 5 change places"},
	{"fifo-path",		"Use a GPM fifo instead of XGrabButton"},
	{NULL,				"Kills the running imwheel process"},
	//{NULL,				"RESERVED: used when imwheel reloads itself"},
	{NULL,				"imwheel process doesn't detach from terminal"},
	{NULL,				"imwheel doesn't check for a pid file, nor write one"},
	{NULL,				"spit out all debugging info (it's a lot!)"},
	{NULL,				"don't start imwheel process, after args"},
	{NULL,				"For help...duh!"},
	{NULL,				NULL}
};
int buttonFlip=False, useFifo=False, detach=True, quit=False, pid_check=True;
int fifofd=-1;
char *fifoName="/dev/gpmwheel";
Bool grabbed;

/*----------------------------------------------------------------------------*/

void main(int argc, char **argv)
{
	Display *d;
	static char *opts="4iW:dDkRqh?";

	getOptions(argc,argv,opts,options);
	setupstatebits();
	d=start(NULL);
	eventLoop(d,argv);
	end(d);
}

/*----------------------------------------------------------------------------*/

void end(Display *d)
{
	XUngrabButton(d, AnyButton, AnyModifier, DefaultRootWindow(d));
	XCloseDisplay(d);
}

/*----------------------------------------------------------------------------*/

void grabButtons(Display *d)
{
	int i;

	Printf("Grab buttons!\n");
	grabbed=True;
	for(i=0;i<NUM_BUTTONS;i++)
	{
		Printf("Grabbing Button %d...\n",i);
		XGrabButton(
			d,
			buttons[i],
			AnyModifier,
			DefaultRootWindow(d),
			False,
			ButtonReleaseMask|ButtonPressMask,
			GrabModeAsync, GrabModeAsync,
			None,
			None
		);
	}
}

/*----------------------------------------------------------------------------*/

void ungrabButtons(Display *d)
{
	int i;

	Printf("Ungrab buttons!\n");
	grabbed=False;
	for(i=0;i<NUM_BUTTONS;i++)
	{
		XUngrabButton(
			d,
			buttons[i],
			AnyModifier,
			DefaultRootWindow(d)
		);
	}
}

/*----------------------------------------------------------------------------*/

Display *start(char *display)
{
	Display *d;

	wa=getRC();
	d=XOpenDisplay(display);
	if(!d)
	{
		fprintf(stderr,"Could not open display, check shell DISPLAY variable, and export or setenv it!\n");
		exit(1);
	}
	//XSync(d,True);
	XAllowEvents(d,AsyncBoth,CurrentTime);
	XAllowEvents(d,SyncBoth,CurrentTime);
	if(!useFifo)
	{
		grabButtons(d);
		XSelectInput(d,DefaultRootWindow(d),PointerMotionMask);
	}
	return(d);
}

/*----------------------------------------------------------------------------*/
char getInput(Display *d, XEvent *e, XModifierKeymap **xmk, char km[32], char *button)
{
	*button=0;
	if(!useFifo)
		XNextEvent(d,e);
	else
	{
		memset(e,0,sizeof(XEvent));
		if(!(read(fifofd,button,1)))
		{
			close(fifofd);
			Printf("Must reopen the GPM fifo...\n");
			openFifo();
			*button=0;
		}
		e->xbutton.button=*button;
		e->type=ButtonPress;
	}
	e->xbutton.button^=buttonFlip;
	*button=e->xbutton.button;
	XQueryKeymap(d,km);
	if(debug)
		printKeymap(d,km);
	*xmk=XGetModifierMapping(d);
	if(debug)
		printXModifierKeymap(d,*xmk);
	return(*button);
}
/*----------------------------------------------------------------------------*/

void eventLoop(Display *d, char **argv)
{
	XEvent e;
	Window pointer_window=0;
	int i,j,k;
	int kc;
	XModifierKeymap *xmk=NULL;
	char km[32],button;
	struct WinAction *wap=NULL;
	Window oldw=0;
	struct {time_t t; int motion;} history[HISTORY_LENGTH];

	XSetErrorHandler((XErrorHandler)nullXError);
	memset(history,0,sizeof(history));
	while(1)
	{
		if(!getInput(d,&e,&xmk,km,&button))
			continue;
		//get current input window & it's name
		XGetInputFocus(d,&e.xbutton.subwindow,&i);
		switch(e.type)
		{
			case MotionNotify:
				if(e.xbutton.subwindow==oldw && grabbed)
					continue;
			case ButtonPress:
				Printf("XGetInputFocus:window=");
				wname=windowName(d,e.xbutton.subwindow);
				Printf("\trevert_to=%d\n",i);
				// get resource and class names
				XGetClassHint(d,e.xbutton.subwindow,&xch);
				Printf("resource name        =\"%s\"\n",xch.res_name);
				Printf("class name           =\"%s\"\n",xch.res_class);
				break;
		}
		oldw=e.xbutton.subwindow;
#ifdef DEBUG
		printXEvent(&e);
#endif
		switch(e.type)
		{
			case MotionNotify:
				Printf("MotionNotify\n");
				if(!useFifo && (wap=findWA(d,UNGRAB,wname,xch.res_name,xch.res_class,NULL,NULL)))
				{
					if(grabbed)
						ungrabButtons(d);
				}
				else
				{
					if(!grabbed)
						grabButtons(d);
				}
				break;
			case ButtonPress:
				Printf("ButtonPress\n");
				// Do configuration check
				XQueryPointer(d,DefaultRootWindow(d),&pointer_window,&pointer_window,&i,&i,&i,&i,&i);
				// Update history
				for(i=0;i<HISTORY_LENGTH-1;i++)
				{
					history[i].motion=history[i+1].motion;
					history[i].t=history[i+1].t;
				}
				history[HISTORY_LENGTH-1].motion=e.xbutton.button;
				history[HISTORY_LENGTH-1].t     =time(NULL);
				// Configure if in root and toggling wheel
				if(!pointer_window)
				{
					for(j=1,i=0;j&&i<HISTORY_LENGTH;i++)
						j=(history[i].motion%2==i%2);
					if(j &&
						history[HISTORY_LENGTH-1].t-history[0].t < CONFIG_TIME)
					{
						Printf("Going to configuration...\n");
						if(!useFifo && grabbed)
							ungrabButtons(d);
						memset(history,0,sizeof(history));
						if(cfg(useFifo?fifofd:-1))
						{
							char **nargv=NULL;

							Printf("Configuration changed...\n");
							Printf("Restarting %s...\n",argv[0]);
							freeAllX(&xch,&xmk,&wname);
							for(i=0;argv[i];i++)
							{
								nargv=realloc(nargv,sizeof(char*)*(i+3));
								nargv[i]=argv[i];
								nargv[i+2]=NULL;
							}
							nargv[i]=strdup("-R");
							execvp(nargv[0],nargv); // run me over me!
							fprintf(stderr,"Restart failed!\n");
							perror(argv[0]);
						}
						memset(history,0,sizeof(history));
						if(!useFifo && grabbed)
							ungrabButtons(d);
						if(useFifo)
							openFifo();
						Printf("No change in configuration\n");
					}
					else
						Printf("No config...\n");
					continue; // No wheel actions needed in root window!
				}
				wap=findWA(d,e.xbutton.button,wname,xch.res_name,xch.res_class,xmk,km);
				XTestGrabControl(d,True);
				if(!wap)
				{
					Printf("Taking default action.\n");
					j=e.xbutton.button-4;
					k=statebits[makeModMask(xmk,km)&STATE_MASK];
					kc=XKeysymToKeycode(d, XStringToKeysym(keys[j][k]));
					Printf("keycode=%d\n",kc);
					for(i=0;i<reps[k]; i++)
					{
						Printf("rep=%d  key='%s'\n",i,keys[j][k]);
						//XSetInputFocus(d,e.xbutton.subwindow,RevertToParent,CurrentTime);
						modMods(d,km,xmk,False,0);
						XTestFakeKeyEvent(d,kc,True,0);
						XTestFakeKeyEvent(d,kc,False,0);
						XSync(d,False);
						modMods(d,km,xmk,True,0);
						XSync(d,False);
					} // rep loop
				}
				else
					doWA(d,(XButtonEvent*)&e.xbutton,xmk,km,wap);
				XTestGrabControl(d,False);
				//XQueryPointer(d,DefaultRootWindow(d),&e.xbutton.subwindow,&e.xbutton.subwindow,&i,&i,&i,&i,&i);
				//XSetInputFocus(d,e.xbutton.subwindow,RevertToParent,CurrentTime);
				break;
		}
		freeAllX(&xch,&xmk,&wname);
	} // infinite loop
}

/*----------------------------------------------------------------------------*/
void freeAllX(XClassHint *xch, XModifierKeymap **xmk, char **wname)
{
	if(xch)
	{
		if(xch->res_name)
		{
			XFree(xch->res_name);
			xch->res_name=NULL;
		}
		if(xch->res_class)
		{
			XFree(xch->res_class);
			xch->res_class=NULL;
		}
	}
	if(xmk && *xmk)
	{
		XFreeModifiermap(*xmk);
		*xmk=NULL;
	}
	if(wname && *wname)
	{
		XFree(*wname);
		*wname=NULL;
	}
}
/*----------------------------------------------------------------------------*/

int *nullXError(Display *d, XErrorEvent *e)
{
	char errorstr[1024];

	grabbed=False;
	Printf("XError: \n");
	Printf("\tserial      : %lu\n",e->serial);
	Printf("\terror_code  : %u\n",e->error_code);
	Printf("\trequest_code: %u\n",e->request_code);
	Printf("\tminor_code  : %u\n",e->minor_code);
	Printf("\tresourceid  : %lu\n",e->resourceid);
	XGetErrorText(d,e->error_code,errorstr,1024);
	Printf("\terror string: %s\n",errorstr);
	return(0);
}

/*----------------------------------------------------------------------------*/
/* vim:ts=4:shiftwidth=4
"*/
