/*
	Copyright (C) 1997 Hewlett-Packard Company
*/
#ifndef timer_h
#define timer_h

#include <sys/types.h>

#include <httperf.h>

#define TIMER_INTERVAL	(1.0/1000)	/* timer granularity in seconds */

struct Timer;
typedef void (*Timer_Callback) (struct Timer *t, Any_Type arg);

typedef struct Timer_Queue
  {
    struct Timer *next;
    struct Timer *prev;
  }
Timer_Queue;

typedef struct Timer
  {
    Timer_Queue q;		/* must be first member! */
    u_long delta;
    Timer_Callback func;
    Any_Type arg;
  }
Timer;

extern Time timer_now_forced (void);
extern Time timer_now (void);

extern void timer_init (void);
/* Needs to be called at least once every TIMER_INTERVAL:  */
extern void timer_tick (void);

extern Timer *timer_schedule (Timer_Callback timeout, Any_Type arg,
			      Time delay);
extern void timer_cancel (Timer *t);

#endif /* timer_h */
