/*
 
              Copyright (C) 1997-1998 Hewlett-Packard Company
                         ALL RIGHTS RESERVED.
 
  The enclosed software and documentation includes copyrighted works
  of Hewlett-Packard Co. For as long as you comply with the following
  limitations, you are hereby authorized to (i) use, reproduce, and
  modify the software and documentation, and to (ii) distribute the
  software and documentation, including modifications, for
  non-commercial purposes only.
      
  1.  The enclosed software and documentation is made available at no
      charge in order to advance the general development of
      high-performance networking and computing products.
 
  2.  You may not delete any copyright notices contained in the
      software or documentation. All hard copies, and copies in
      source code or object code form, of the software or
      documentation (including modifications) must contain at least
      one of the copyright notices.
 
  3.  The enclosed software and documentation has not been subjected
      to testing and quality control and is not a Hewlett-Packard Co.
      product. At a future time, Hewlett-Packard Co. may or may not
      offer a version of the software and documentation as a product.
  
  4.  THE SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS".
      HEWLETT-PACKARD COMPANY DOES NOT WARRANT THAT THE USE,
      REPRODUCTION, MODIFICATION OR DISTRIBUTION OF THE SOFTWARE OR
      DOCUMENTATION WILL NOT INFRINGE A THIRD PARTY'S INTELLECTUAL
      PROPERTY RIGHTS. HP DOES NOT WARRANT THAT THE SOFTWARE OR
      DOCUMENTATION IS ERROR FREE. HP DISCLAIMS ALL WARRANTIES,
      EXPRESS AND IMPLIED, WITH REGARD TO THE SOFTWARE AND THE
      DOCUMENTATION. HP SPECIFICALLY DISCLAIMS ALL WARRANTIES OF
      MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
  
  5.  HEWLETT-PACKARD COMPANY WILL NOT IN ANY EVENT BE LIABLE FOR ANY
      DIRECT, INDIRECT, SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES
      (INCLUDING LOST PROFITS) RELATED TO ANY USE, REPRODUCTION,
      MODIFICATION, OR DISTRIBUTION OF THE SOFTWARE OR DOCUMENTATION.
 
*/
#include <assert.h>
#include <errno.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <sys/time.h>

#include <httperf.h>
#include <timer.h>

#define WHEEL_SIZE	4096

#if 1
static Time now;
#endif
static Time next_tick;
static Timer *timer_free_list = 0;
static Timer *t_curr = 0;

/* What a wheel is made of, no?  */
static Timer_Queue wheel[WHEEL_SIZE], *curr = 0;

static void
done (Timer *t)
{
  t->q.next = timer_free_list;
  t->q.prev = 0;
  timer_free_list = t;
}

Time
timer_now_forced (void)
{
  struct timeval tv;

  gettimeofday (&tv, 0);
  return tv.tv_sec + tv.tv_usec*1e-6;
}

Time
timer_now (void)
{
  return now;
}

void
timer_init (void)
{
  now = timer_now_forced ();
  memset (wheel, 0, sizeof (wheel));
  next_tick = timer_now () + TIMER_INTERVAL;
  curr = wheel;
}

void
timer_tick (void)
{
  Timer *t, *t_next;

  assert (!t_curr);

  now = timer_now_forced ();

  while (timer_now () >= next_tick)
    {
      for (t = curr->next; t && t->delta == 0; t = t_next)
	{
	  t_curr = t;
	  (*t->func) (t, t->arg);
	  t_next = t->q.next;
	  done (t);
	}
      t_curr = 0;
      curr->next = t;
      if (t)
	{
	  t->q.prev = (Timer *) curr;
	  --t->delta;
	}
      next_tick += TIMER_INTERVAL;
      if (++curr >= wheel + WHEEL_SIZE)
	curr = wheel;
    }
}

Timer*
timer_schedule (Timer_Callback timeout, Any_Type arg, Time delay)
{
  Timer_Queue *spoke;
  Timer *t, *p;
  u_long ticks;
  u_long delta;
  Time behind;

  if (timer_free_list)
    {
      t = timer_free_list;
      timer_free_list = t->q.next;
    }
  else
    {
      t = malloc (sizeof (*t));
      if (!t)
	{
	  fprintf (stderr, "%s.timer_schedule: %s\n",
		   prog_name, strerror (errno));
	  return 0;
	}
    }
  memset (t, 0, sizeof (*t));
  t->func = timeout;
  t->arg = arg;

  behind = (timer_now () - next_tick);
  if (behind > 0.0)
    delay += behind;

  if (delay < 0.0)
    ticks = 1;
  else
    {
      ticks = (delay + TIMER_INTERVAL / 2.0) * (1.0 / TIMER_INTERVAL);
      if (!ticks)
	ticks = 1;			/* minimum delay is a tick */
    }

  spoke = curr + (ticks % WHEEL_SIZE);
  if (spoke >= wheel + WHEEL_SIZE)
    spoke -= WHEEL_SIZE;

  delta = ticks / WHEEL_SIZE;
  p = (Timer *) spoke;
  while (p->q.next && delta > p->q.next->delta)
    {
      delta -= p->q.next->delta;
      p = p->q.next;
    }
  t->q.next = p->q.next;
  t->q.prev = p;
  p->q.next = t;
  t->delta = delta;
  if (t->q.next)
    {
      t->q.next->q.prev = t;
      t->q.next->delta -= delta;
    }

  if (DBG > 2)
    fprintf (stderr, "timer_schedule: t=%p, delay=%gs, arg=%lx\n",
	     t, delay, arg.l);

  return t;
}

void
timer_cancel (Timer *t)
{
  if (DBG > 2)
    fprintf (stderr, "timer_cancel: t=%p\n", t);

  assert (t->q.prev);

  /* A module MUST NOT call timer_cancel() for a timer that is
     currently being processed (whose timeout has expired).  */
  if (t_curr == t)
    {
      fprintf (stderr, "timer_cancel() called on currently active timer!\n");
      return;
    }

  if (t->q.next)
    {
      t->q.next->delta += t->delta;
      t->q.next->q.prev = t->q.prev;
    }
  t->q.prev->q.next = t->q.next;
  done (t);
}
