/*
 
              Copyright (C) 1998 Hewlett-Packard Company
                         ALL RIGHTS RESERVED.
 
  The enclosed software and documentation includes copyrighted works
  of Hewlett-Packard Co. For as long as you comply with the following
  limitations, you are hereby authorized to (i) use, reproduce, and
  modify the software and documentation, and to (ii) distribute the
  software and documentation, including modifications, for
  non-commercial purposes only.
      
  1.  The enclosed software and documentation is made available at no
      charge in order to advance the general development of
      high-performance networking and computing products.
 
  2.  You may not delete any copyright notices contained in the
      software or documentation. All hard copies, and copies in
      source code or object code form, of the software or
      documentation (including modifications) must contain at least
      one of the copyright notices.
 
  3.  The enclosed software and documentation has not been subjected
      to testing and quality control and is not a Hewlett-Packard Co.
      product. At a future time, Hewlett-Packard Co. may or may not
      offer a version of the software and documentation as a product.
  
  4.  THE SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS".
      HEWLETT-PACKARD COMPANY DOES NOT WARRANT THAT THE USE,
      REPRODUCTION, MODIFICATION OR DISTRIBUTION OF THE SOFTWARE OR
      DOCUMENTATION WILL NOT INFRINGE A THIRD PARTY'S INTELLECTUAL
      PROPERTY RIGHTS. HP DOES NOT WARRANT THAT THE SOFTWARE OR
      DOCUMENTATION IS ERROR FREE. HP DISCLAIMS ALL WARRANTIES,
      EXPRESS AND IMPLIED, WITH REGARD TO THE SOFTWARE AND THE
      DOCUMENTATION. HP SPECIFICALLY DISCLAIMS ALL WARRANTIES OF
      MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
  
  5.  HEWLETT-PACKARD COMPANY WILL NOT IN ANY EVENT BE LIABLE FOR ANY
      DIRECT, INDIRECT, SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES
      (INCLUDING LOST PROFITS) RELATED TO ANY USE, REPRODUCTION,
      MODIFICATION, OR DISTRIBUTION OF THE SOFTWARE OR DOCUMENTATION.
 
*/
/* This statistics collector simply prints the replies received from
   the server.  */

#include <assert.h>
#include <stdio.h>

#include <httperf.h>
#include <call.h>
#include <conn.h>
#include <event.h>

static void
print_buf (Call *call, const char *buf, int len)
{
  static int prev_id = -1;
  static int had_newline = 1;

  if (prev_id != call->id)
    {
      if (!had_newline)
	putchar ('\n');
      printf ("#<<<< %ld\n", call->id);
    }
  if (len > 0)
    {
      printf ("%.*s", len, buf);
      had_newline = (buf[len - 1] == '\n');
    }
  prev_id = call->id;
}

static void
recv_data (Event_Type et, Object *obj, Any_Type regarg, Any_Type callarg)
{
  struct iovec *iov;
  Call *call;

  assert (et == EV_CALL_RECV_DATA && object_is_call (obj));
  call = (Call *) obj;
  iov = callarg.vp;

  print_buf (call, iov->iov_base, iov->iov_len);
}

static void
recv_stop (Event_Type et, Object *obj, Any_Type regarg, Any_Type callarg)
{
  Call *call;

  assert (et == EV_CALL_RECV_STOP && object_is_call (obj));
  call = (Call *) obj;

  print_buf (call, "", 0);
  printf ("#>>>> %ld\n", call->id);
}

static void
init (void)
{
  Any_Type arg;

  arg.l = 0;
  event_register_handler (EV_CALL_RECV_DATA, recv_data, arg);
  event_register_handler (EV_CALL_RECV_STOP, recv_stop, arg);
}

Stat_Collector stats_print_reply =
  {
    "Reply printer",
    init,
    no_op,
    no_op,
    no_op
  };
