/*
	Copyright (C) 1998 Hewlett-Packard Company
*/
#ifndef sess_h
#define sess_h

#include <sys/types.h>

#include <httperf.h>
#include <object.h>

/* Sessions are not used by the httperf's core itself, but they are
   provided here for the benefit of workload generators that need such
   a notion (e.g., to represent users).  */
typedef struct Sess
  {
    Object obj;
  }
Sess;

/* Initialize the new session object S.  */
extern void sess_init (Sess *s);

/* Destroy the session-specific state in session object S.  */
extern void sess_deinit (Sess *s);

/* Session S failed.  This causes EV_SESS_FAILED to be signalled and
   gives up the caller's reference to S.  */
extern void sess_failure (Sess *s);

#define sess_new()	((Sess *) object_new (OBJ_SESS))
#define sess_inc_ref(s)	object_inc_ref ((Object *) (s))
#define sess_dec_ref(s)	object_dec_ref ((Object *) (s))

#endif /* sess_h */
