/*
	Copyright (C) 1997, 1998 Hewlett-Packard Company
*/
#ifndef httperf_h
#define httperf_h

#include <sys/time.h>
#include <sys/types.h>
#include <sys/resource.h>

#define VERSION	"0.6"

typedef double Time;

#define NELEMS(a)	((sizeof (a)) / sizeof ((a)[0]))
#define TV_TO_SEC(tv)	((tv).tv_sec + 1e-6*(tv).tv_usec)

typedef union
  {
    char c;
    int i;
    long l;
    u_char uc;
    u_int ui;
    u_long ul;
    float f;
    double d;
    void *vp;
    const void *cvp;
  }
Any_Type;

typedef enum Dist_Type
  {
    DETERMINISTIC,	/* also called fixed-rate */
    UNIFORM,		/* over interval [min_iat,max_iat) */
    EXPONENTIAL		/* with mean mean_iat */
  }
Dist_Type;

typedef struct Load_Generator
  {
    const char *name;
    void (*init) (void);
    void (*start) (void);
    void (*stop) (void);
  }
Load_Generator;

typedef struct Stat_Collector
  {
    const char *name;
    /* START and STOP are timing sensitive, so they should be as short
       as possible.  More expensive stuff can be done during INIT and
       DUMP.  */
    void (*init) (void);
    void (*start) (void);
    void (*stop) (void);
    void (*dump) (void);
  }
Stat_Collector;

typedef struct Rate_Info
  {
    Dist_Type dist;		/* interarrival distribution */
    double rate_param;		/* 0 if mean_iat==0, else 1/mean_iat */
    Time mean_iat;		/* mean interarrival time */
    Time min_iat;		/* min interarrival time (for UNIFORM) */
    Time max_iat;	        /* max interarrival time (for UNIFORM) */
  }
Rate_Info;

typedef struct Cmdline_Params
  {
    int http_version;	/* (default) HTTP protocol version */
    const char *server;	/* (default) hostname */
    int port;		/* (default) server port */
    const char *uri;	/* (default) uri */
    Rate_Info rate;
    Time timeout;	/* watchdog timeout */
    Time think_timeout;	/* timeout for server think time */
    int num_conns;	/* # of connections to generate */
    int num_calls;	/* # of calls to generate per connection */
    int burst_len;	/* # of calls to burst back-to-back */
    int max_piped;	/* max # of piped calls per connection */
    int max_conns;	/* max # of connections per session */
    int hog;		/* client may hog as much resources as possible */
    int send_buffer_size;
    int recv_buffer_size;
    int failure_status;	/* status code that should be considered failure */
    int close_with_reset; /* close connections with TCP RESET? */
    int print_replies;	/* print replies to stdout? */
    int session_cookies; /* handle set-cookies? (at the session level) */
    struct
      {
	u_int id;
	u_int num_clients;
      }
    client;
    struct
      {
	char *file;	/* name of the file where entries are */
	char do_loop;	/* boolean indicating if we want to loop on entries */
      }
    wlog;
    struct
      {
	u_int num_sessions;	/* # of user-sessions */
	u_int num_calls;	/* # of calls per user-session */
	Time think_time;	/* user think time between calls */
      }
    wsess;
    struct
      {
	u_int num_sessions;	/* # of user-sessions */
	Time think_time;	/* user think time between calls */
	char *file;		/* name of the file where session defs are */
      }
    wsesslog;
    struct
      {
	u_int num_files;
	double target_miss_rate;
      }
    wset;
  }
Cmdline_Params;

extern const char *prog_name;
extern int verbose;
extern Cmdline_Params param;
extern Time test_time_start;
extern Time test_time_stop;
extern struct rusage test_rusage_start;
extern struct rusage test_rusage_stop;

#ifdef DEBUG
  extern int debug_level;
# define DBG debug_level
#else
# define DBG 0
#endif

extern void panic (const char *msg, ...);
extern void no_op (void);

#endif /* httperf_h */
