/*
 
              Copyright (C) 1997-1998 Hewlett-Packard Company
                         ALL RIGHTS RESERVED.
 
  The enclosed software and documentation includes copyrighted works
  of Hewlett-Packard Co. For as long as you comply with the following
  limitations, you are hereby authorized to (i) use, reproduce, and
  modify the software and documentation, and to (ii) distribute the
  software and documentation, including modifications, for
  non-commercial purposes only.
      
  1.  The enclosed software and documentation is made available at no
      charge in order to advance the general development of
      high-performance networking and computing products.
 
  2.  You may not delete any copyright notices contained in the
      software or documentation. All hard copies, and copies in
      source code or object code form, of the software or
      documentation (including modifications) must contain at least
      one of the copyright notices.
 
  3.  The enclosed software and documentation has not been subjected
      to testing and quality control and is not a Hewlett-Packard Co.
      product. At a future time, Hewlett-Packard Co. may or may not
      offer a version of the software and documentation as a product.
  
  4.  THE SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS".
      HEWLETT-PACKARD COMPANY DOES NOT WARRANT THAT THE USE,
      REPRODUCTION, MODIFICATION OR DISTRIBUTION OF THE SOFTWARE OR
      DOCUMENTATION WILL NOT INFRINGE A THIRD PARTY'S INTELLECTUAL
      PROPERTY RIGHTS. HP DOES NOT WARRANT THAT THE SOFTWARE OR
      DOCUMENTATION IS ERROR FREE. HP DISCLAIMS ALL WARRANTIES,
      EXPRESS AND IMPLIED, WITH REGARD TO THE SOFTWARE AND THE
      DOCUMENTATION. HP SPECIFICALLY DISCLAIMS ALL WARRANTIES OF
      MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
  
  5.  HEWLETT-PACKARD COMPANY WILL NOT IN ANY EVENT BE LIABLE FOR ANY
      DIRECT, INDIRECT, SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES
      (INCLUDING LOST PROFITS) RELATED TO ANY USE, REPRODUCTION,
      MODIFICATION, OR DISTRIBUTION OF THE SOFTWARE OR DOCUMENTATION.
 
*/
/* Causes accesses to a fixed set of files (working set) in such a way
   that is likely to cause disk I/O with a certain probability.  */

#include <assert.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <httperf.h>
#include <call.h>
#include <event.h>

#define MAX_URI_LEN		128
#define CALL_PRIVATE_DATA(c) \
 ((void *) ((char *)(c) + call_private_data_offset))

static double miss_prob;
static unsigned file_num;
static size_t call_private_data_offset;
static size_t uri_prefix_len;

static void
set_uri (Event_Type et, Call *c)
{
  char *cp, *buf_end;
  unsigned j, n;

  assert (et == EV_CALL_NEW && object_is_call (c));

  miss_prob += param.wset.target_miss_rate;
  if (miss_prob >= 1.0)
    {
      /* generate (what we hope to be) a miss */
      miss_prob -= 1.0;
      file_num += param.client.num_clients;
      if (file_num >= param.wset.num_files)
	file_num -= param.wset.num_files;
    }

  /* fill in extension: */
  buf_end = (char *) CALL_PRIVATE_DATA (c) + MAX_URI_LEN;
  cp = buf_end - 6;
  memcpy (cp, ".html", 6);

  /* fill in file & pathname: */
  n = file_num;
  for (j = 1; j < param.wset.num_files; j *= 10, n /= 10)
    {
      cp -= 2;
      cp[0] = '/'; cp[1] = '0' + (n % 10);
    }

  /* fill in the uri prefix specified by param.uri: */
  cp -= uri_prefix_len;
  if (cp < (char *) CALL_PRIVATE_DATA (c))
    {
      fprintf (stderr, "%s.uri_wset: URI buffer overflow!\n", prog_name);
      exit (1);
    }
  memcpy (cp, param.uri, uri_prefix_len);

  call_set_uri (c, cp, (buf_end - cp) - 1);

  if (verbose)
    printf ("%s: accessing URI `%s'\n", prog_name, cp);
}

static void
init (void)
{
  Any_Type arg;

  miss_prob = drand48 ();
  file_num = param.client.id;

  call_private_data_offset = object_expand (OBJ_CALL, MAX_URI_LEN);

  uri_prefix_len = strlen (param.uri);
  if (param.uri[uri_prefix_len - 1] == '/')
    {
      ++param.uri;
      --uri_prefix_len;
    }

  arg.l = 0;
  event_register_handler (EV_CALL_NEW, (Event_Handler) set_uri, arg);
}

Load_Generator uri_wset =
  {
    "Generates URIs accessing a working-set at a given rate",
    init,
    no_op,
    no_op
  };
