/*
 
              Copyright (C) 1997, 1998 Hewlett-Packard Company
                         ALL RIGHTS RESERVED.
 
  The enclosed software and documentation includes copyrighted works
  of Hewlett-Packard Co. For as long as you comply with the following
  limitations, you are hereby authorized to (i) use, reproduce, and
  modify the software and documentation, and to (ii) distribute the
  software and documentation, including modifications, for
  non-commercial purposes only.
      
  1.  The enclosed software and documentation is made available at no
      charge in order to advance the general development of
      high-performance networking and computing products.
 
  2.  You may not delete any copyright notices contained in the
      software or documentation. All hard copies, and copies in
      source code or object code form, of the software or
      documentation (including modifications) must contain at least
      one of the copyright notices.
 
  3.  The enclosed software and documentation has not been subjected
      to testing and quality control and is not a Hewlett-Packard Co.
      product. At a future time, Hewlett-Packard Co. may or may not
      offer a version of the software and documentation as a product.
  
  4.  THE SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS".
      HEWLETT-PACKARD COMPANY DOES NOT WARRANT THAT THE USE,
      REPRODUCTION, MODIFICATION OR DISTRIBUTION OF THE SOFTWARE OR
      DOCUMENTATION WILL NOT INFRINGE A THIRD PARTY'S INTELLECTUAL
      PROPERTY RIGHTS. HP DOES NOT WARRANT THAT THE SOFTWARE OR
      DOCUMENTATION IS ERROR FREE. HP DISCLAIMS ALL WARRANTIES,
      EXPRESS AND IMPLIED, WITH REGARD TO THE SOFTWARE AND THE
      DOCUMENTATION. HP SPECIFICALLY DISCLAIMS ALL WARRANTIES OF
      MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
  
  5.  HEWLETT-PACKARD COMPANY WILL NOT IN ANY EVENT BE LIABLE FOR ANY
      DIRECT, INDIRECT, SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES
      (INCLUDING LOST PROFITS) RELATED TO ANY USE, REPRODUCTION,
      MODIFICATION, OR DISTRIBUTION OF THE SOFTWARE OR DOCUMENTATION.
 
*/
/* Creates connections at the fixed rate PARAM.RATE or sequentially if
   PARAM.RATE is zero.  */

#include <assert.h>
#include <stdio.h>

#include <httperf.h>
#include <core.h>
#include <event.h>
#include <rate.h>
#include <conn.h>
#include <timer.h>

static int num_conns_generated;
static int num_conns_destroyed;
static Rate_Generator rg;

static int
make_conn (Any_Type arg)
{
  Conn *s;

  if (num_conns_generated++ >= param.num_conns)
    return -1;

  s = conn_new ();
  if (!s)
    return -1;

  core_connect (s);
  return 0;
}

static void
destroyed (void)
{
  if (++num_conns_destroyed >= param.num_conns)
    core_exit ();
}

static void
init (void)
{
  Any_Type arg;

  rg.arg.l = 0;
  rg.tick = make_conn;

  arg.l = 0;
  event_register_handler (EV_CONN_DESTROYED, (Event_Handler) destroyed, arg);
}

static void
start (void)
{
  rg.rate = &param.rate;
  rate_generator_start (&rg, EV_CONN_DESTROYED);
}

Load_Generator conn_rate =
  {
    "creates connections at a fixed rate",
    init,
    start,
    no_op
  };
