/*
 
              Copyright (C) 1997, 1998 Hewlett-Packard Company
                         ALL RIGHTS RESERVED.
 
  The enclosed software and documentation includes copyrighted works
  of Hewlett-Packard Co. For as long as you comply with the following
  limitations, you are hereby authorized to (i) use, reproduce, and
  modify the software and documentation, and to (ii) distribute the
  software and documentation, including modifications, for
  non-commercial purposes only.
      
  1.  The enclosed software and documentation is made available at no
      charge in order to advance the general development of
      high-performance networking and computing products.
 
  2.  You may not delete any copyright notices contained in the
      software or documentation. All hard copies, and copies in
      source code or object code form, of the software or
      documentation (including modifications) must contain at least
      one of the copyright notices.
 
  3.  The enclosed software and documentation has not been subjected
      to testing and quality control and is not a Hewlett-Packard Co.
      product. At a future time, Hewlett-Packard Co. may or may not
      offer a version of the software and documentation as a product.
  
  4.  THE SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS".
      HEWLETT-PACKARD COMPANY DOES NOT WARRANT THAT THE USE,
      REPRODUCTION, MODIFICATION OR DISTRIBUTION OF THE SOFTWARE OR
      DOCUMENTATION WILL NOT INFRINGE A THIRD PARTY'S INTELLECTUAL
      PROPERTY RIGHTS. HP DOES NOT WARRANT THAT THE SOFTWARE OR
      DOCUMENTATION IS ERROR FREE. HP DISCLAIMS ALL WARRANTIES,
      EXPRESS AND IMPLIED, WITH REGARD TO THE SOFTWARE AND THE
      DOCUMENTATION. HP SPECIFICALLY DISCLAIMS ALL WARRANTIES OF
      MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
  
  5.  HEWLETT-PACKARD COMPANY WILL NOT IN ANY EVENT BE LIABLE FOR ANY
      DIRECT, INDIRECT, SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES
      (INCLUDING LOST PROFITS) RELATED TO ANY USE, REPRODUCTION,
      MODIFICATION, OR DISTRIBUTION OF THE SOFTWARE OR DOCUMENTATION.
 
*/
/* Issue a sequence of calls on a connection.  */

#include <assert.h>

#include <httperf.h>
#include <call.h>
#include <core.h>
#include <event.h>
#include <conn.h>

#define CONN_PRIVATE_DATA(c) \
  ((Conn_Private_Data *) ((char *)(c) + conn_private_data_offset))

#define MIN(a,b)	((a) < (b) ? (a) : (b))

typedef struct Conn_Private_Data
  {
    int num_calls;
    int num_completed;
    int num_destroyed;
  }
Conn_Private_Data;

static size_t conn_private_data_offset;

static void
issue_calls (Conn *conn)
{
  Conn_Private_Data *priv;
  Call *call;
  int i;

  priv = CONN_PRIVATE_DATA (conn);
  priv->num_completed = 0;
  priv->num_destroyed = 0;

  for (i = 0; i < param.burst_len; ++i)
    if (priv->num_calls++ < param.num_calls)
      {
	call = call_new ();
	if (call)
	  {
	    core_send (conn, call);
	    call_dec_ref (call);
	  }
      }
}

static void
conn_connected (Event_Type et, Conn *conn)
{
  assert (et == EV_CONN_CONNECTED && object_is_conn (conn));

  issue_calls (conn);
}

static void
call_done (Event_Type et, Call *call)
{
  Conn *conn = call->conn;
  Conn_Private_Data *priv;

  assert (et == EV_CALL_RECV_STOP && conn && object_is_conn (conn));

  priv = CONN_PRIVATE_DATA (conn);
  ++priv->num_completed;
}

static void
call_destroyed (Event_Type et, Call *call)
{
  Conn_Private_Data *priv;
  Conn *conn;

  assert (et == EV_CALL_DESTROYED && object_is_call (call));

  conn = call->conn;
  priv = CONN_PRIVATE_DATA (conn);

  if (++priv->num_destroyed >= MIN (param.burst_len, param.num_calls))
    {
      if (priv->num_completed == priv->num_destroyed
	  && priv->num_calls < param.num_calls)
	issue_calls (conn);
      else
	core_close (conn);
    }
}

static void
init (void)
{
  Any_Type arg;

  conn_private_data_offset = object_expand (OBJ_CONN,
					    sizeof (Conn_Private_Data));

  arg.l = 0;
  event_register_handler (EV_CONN_CONNECTED, (Event_Handler) conn_connected,
			  arg);
  event_register_handler (EV_CALL_RECV_STOP, (Event_Handler) call_done, arg);
  event_register_handler (EV_CALL_DESTROYED, (Event_Handler) call_destroyed,
			  arg);
}

Load_Generator call_seq =
  {
    "performs a sequence of calls on a connection",
    init,
    no_op,
    no_op
  };
