/*
 
              Copyright (C) 1997-1998, 1998 Hewlett-Packard Company
                         ALL RIGHTS RESERVED.
 
  The enclosed software and documentation includes copyrighted works
  of Hewlett-Packard Co. For as long as you comply with the following
  limitations, you are hereby authorized to (i) use, reproduce, and
  modify the software and documentation, and to (ii) distribute the
  software and documentation, including modifications, for
  non-commercial purposes only.
      
  1.  The enclosed software and documentation is made available at no
      charge in order to advance the general development of
      high-performance networking and computing products.
 
  2.  You may not delete any copyright notices contained in the
      software or documentation. All hard copies, and copies in
      source code or object code form, of the software or
      documentation (including modifications) must contain at least
      one of the copyright notices.
 
  3.  The enclosed software and documentation has not been subjected
      to testing and quality control and is not a Hewlett-Packard Co.
      product. At a future time, Hewlett-Packard Co. may or may not
      offer a version of the software and documentation as a product.
  
  4.  THE SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS".
      HEWLETT-PACKARD COMPANY DOES NOT WARRANT THAT THE USE,
      REPRODUCTION, MODIFICATION OR DISTRIBUTION OF THE SOFTWARE OR
      DOCUMENTATION WILL NOT INFRINGE A THIRD PARTY'S INTELLECTUAL
      PROPERTY RIGHTS. HP DOES NOT WARRANT THAT THE SOFTWARE OR
      DOCUMENTATION IS ERROR FREE. HP DISCLAIMS ALL WARRANTIES,
      EXPRESS AND IMPLIED, WITH REGARD TO THE SOFTWARE AND THE
      DOCUMENTATION. HP SPECIFICALLY DISCLAIMS ALL WARRANTIES OF
      MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
  
  5.  HEWLETT-PACKARD COMPANY WILL NOT IN ANY EVENT BE LIABLE FOR ANY
      DIRECT, INDIRECT, SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES
      (INCLUDING LOST PROFITS) RELATED TO ANY USE, REPRODUCTION,
      MODIFICATION, OR DISTRIBUTION OF THE SOFTWARE OR DOCUMENTATION.
 
*/
#include <assert.h>
#include <stdio.h>

#include <httperf.h>
#include <event.h>

#define MAX_NUM_OPS	4

static const char * const event_name[EV_NUM_EVENT_TYPES] =
  {
    "EV_PERF_SAMPLE",
    "EV_HOSTNAME_LOOKUP_START",
    "EV_HOSTNAME_LOOKUP_STOP",
    "EV_SESS_NEW",
    "EV_SESS_FAILED",
    "EV_SESS_DESTROYED",
    "EV_CONN_NEW",
    "EV_CONN_CONNECTING",
    "EV_CONN_CONNECTED",
    "EV_CONN_CLOSE",
    "EV_CONN_DESTROYED",
    "EV_CONN_FAILED",
    "EV_CONN_TIMEOUT",
    "EV_CALL_NEW",
    "EV_CALL_ISSUE",
    "EV_CALL_SEND_START",
    "EV_CALL_SEND_STOP",
    "EV_CALL_RECV_START",
    "EV_CALL_RECV_HDR",
    "EV_CALL_RECV_DATA",
    "EV_CALL_RECV_FOOTER",
    "EV_CALL_RECV_STOP",
    "EV_CALL_DESTROYED"
  };

typedef struct Event_Action
  {
    int num_ops;
    struct closure
      {
	Event_Handler op;
	Any_Type arg;
      }
    closure[MAX_NUM_OPS];
  }
Event_Action;

static Event_Action action[EV_NUM_EVENT_TYPES] = {{0, }};

void
event_register_handler (Event_Type et, Event_Handler handler, Any_Type arg)
{
  struct closure *c;
  int n;

  n = action[et].num_ops;
  if (n >= MAX_NUM_OPS)
    {
      fprintf (stderr, "event_register_handler: sorry, attempted to register "
	       "more than %d handlers\n", MAX_NUM_OPS);
      exit (1);
    }
  c = action[et].closure + n;
  c->op = handler;
  c->arg = arg;
  action[et].num_ops = n + 1;
}

void
event_signal (Event_Type type, Object *obj, Any_Type arg)
{
  Event_Action *act = action + type;
  struct closure *c, *end;

  if (DBG > 1)
    {
      assert (NELEMS (event_name) == EV_NUM_EVENT_TYPES);
      fprintf (stderr, "event_signal: %s (obj=%p,arg=%lx)\n",
	       event_name[type], obj, arg.l);
    }

  end = &act->closure[act->num_ops];
  for (c = &act->closure[0]; c < end; ++c)
    (*c->op) (type, obj, c->arg, arg);
}
