/*
              Copyright (C) 1997, 1998 Hewlett-Packard Company
                         ALL RIGHTS RESERVED.
 
  The enclosed software and documentation includes copyrighted works
  of Hewlett-Packard Co. For as long as you comply with the following
  limitations, you are hereby authorized to (i) use, reproduce, and
  modify the software and documentation, and to (ii) distribute the
  software and documentation, including modifications, for
  non-commercial purposes only.
      
  1.  The enclosed software and documentation is made available at no
      charge in order to advance the general development of
      high-performance networking and computing products.
 
  2.  You may not delete any copyright notices contained in the
      software or documentation. All hard copies, and copies in
      source code or object code form, of the software or
      documentation (including modifications) must contain at least
      one of the copyright notices.
 
  3.  The enclosed software and documentation has not been subjected
      to testing and quality control and is not a Hewlett-Packard Co.
      product. At a future time, Hewlett-Packard Co. may or may not
      offer a version of the software and documentation as a product.
  
  4.  THE SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS".
      HEWLETT-PACKARD COMPANY DOES NOT WARRANT THAT THE USE,
      REPRODUCTION, MODIFICATION OR DISTRIBUTION OF THE SOFTWARE OR
      DOCUMENTATION WILL NOT INFRINGE A THIRD PARTY'S INTELLECTUAL
      PROPERTY RIGHTS. HP DOES NOT WARRANT THAT THE SOFTWARE OR
      DOCUMENTATION IS ERROR FREE. HP DISCLAIMS ALL WARRANTIES,
      EXPRESS AND IMPLIED, WITH REGARD TO THE SOFTWARE AND THE
      DOCUMENTATION. HP SPECIFICALLY DISCLAIMS ALL WARRANTIES OF
      MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
  
  5.  HEWLETT-PACKARD COMPANY WILL NOT IN ANY EVENT BE LIABLE FOR ANY
      DIRECT, INDIRECT, SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES
      (INCLUDING LOST PROFITS) RELATED TO ANY USE, REPRODUCTION,
      MODIFICATION, OR DISTRIBUTION OF THE SOFTWARE OR DOCUMENTATION.
 
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <httperf.h>
#include <call.h>
#include <conn.h>

static u_long next_id = 0;

void
call_init (Call *c)
{
# define DEFAULT_METHOD	"GET"

  c->id = next_id++;
  call_set_method (c, DEFAULT_METHOD, sizeof (DEFAULT_METHOD) - 1);
  c->req.version = param.http_version;
  c->req.iov[IE_BLANK].iov_base = (caddr_t) " ";
  c->req.iov[IE_BLANK].iov_len = 1;
  c->req.iov[IE_NEWLINE1].iov_base = (caddr_t) "\r\n";
  c->req.iov[IE_NEWLINE1].iov_len = 2;
  c->req.iov[IE_NEWLINE2].iov_base = (caddr_t) "\r\n";
  c->req.iov[IE_NEWLINE2].iov_len = 2;
}

void
call_deinit (Call *call)
{
}

int
call_append_request_header (Call *c, const char *hdr, size_t len)
{
  u_int num_hdrs = c->req.num_extra_hdrs;

  if (num_hdrs >= MAX_EXTRA_HEADERS)
    {
      fprintf (stderr, "%s.call_append_request_header: max headers "
	       "(%d) exceeded.\n", prog_name, MAX_EXTRA_HEADERS);
      return -1;
    }
  c->req.iov[IE_FIRST_HEADER + num_hdrs].iov_base = (caddr_t) hdr;
  c->req.iov[IE_FIRST_HEADER + num_hdrs].iov_len = len;
  c->req.num_extra_hdrs = num_hdrs + 1;
  return 0;
}
