/*
 * Copyright (c) 1999 Kungliga Tekniska Hgskolan
 * (Royal Institute of Technology, Stockholm, Sweden).
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *      This product includes software developed by the Kungliga Tekniska
 *      Hgskolan and its contributors.
 * 
 * 4. Neither the name of the Institute nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE INSTITUTE AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE INSTITUTE OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

/* $Id: xfs_vops.c,v 1.1 1999/07/12 11:25:56 lha Exp $ */

#include <xfs_locl.h>

/*
 * Create/open entry
 */


NTSTATUS 
xfs_create (PDEVICE_OBJECT device, PIRP irp)
{
    ASSERT (device && irp);

    xfs_log (device,
	     IoGetCurrentIrpStackLocation(irp)->MajorFunction,
	     0,
	     0,
	     STATUS_SUCCESS,
	     1,
	     xfs_log_new_seq(),
	     0,
	     0,
	     NULL,
	     0,
	     NULL);


    irp->IoStatus.Status = STATUS_SUCCESS;
    irp->IoStatus.Information = FILE_OPENED;
    IoCompleteRequest(irp, IO_NO_INCREMENT);

    return STATUS_SUCCESS;
}


/*
 *
 */

NTSTATUS 
xfs_close (PDEVICE_OBJECT device, PIRP irp)
{
    irp->IoStatus.Status = STATUS_SUCCESS;
    irp->IoStatus.Information = FILE_OPENED;
    IoCompleteRequest(irp, IO_NO_INCREMENT);

    return STATUS_SUCCESS;
}

/*
 *
 */

NTSTATUS 
xfs_read (PDEVICE_OBJECT device, PIRP irp)
{
    irp->IoStatus.Status = STATUS_NO_MEDIA_IN_DEVICE;
    irp->IoStatus.Information = 0;
    IoCompleteRequest(irp, IO_NO_INCREMENT);
     
    return STATUS_NO_MEDIA_IN_DEVICE;
}

/*
 *
 */

NTSTATUS 
xfs_write (PDEVICE_OBJECT device, PIRP irp)
{
    irp->IoStatus.Status = STATUS_NO_MEDIA_IN_DEVICE;
    irp->IoStatus.Information = 0;
    IoCompleteRequest(irp, IO_NO_INCREMENT);
     
    return STATUS_NO_MEDIA_IN_DEVICE;
}

/*
 *
 */

NTSTATUS 
xfs_fileinfo (PDEVICE_OBJECT device, PIRP irp)
{
    irp->IoStatus.Status = STATUS_NO_MEDIA_IN_DEVICE;
    irp->IoStatus.Information = 0;
    IoCompleteRequest(irp, IO_NO_INCREMENT);
     
    return STATUS_NO_MEDIA_IN_DEVICE;
}

/*
 *
 */

NTSTATUS 
xfs_flush (PDEVICE_OBJECT device, PIRP irp)
{
    irp->IoStatus.Status = STATUS_SUCCESS;
    irp->IoStatus.Information = 0;
    IoCompleteRequest(irp, IO_NO_INCREMENT);
     
    return STATUS_SUCCESS;
}

/*
 *
 */

NTSTATUS 
xfs_dirctl (PDEVICE_OBJECT device, PIRP irp)
{
    irp->IoStatus.Status = STATUS_NO_MEDIA_IN_DEVICE;
    irp->IoStatus.Information = 0;
    IoCompleteRequest(irp, IO_NO_INCREMENT);
     
    return STATUS_NO_MEDIA_IN_DEVICE;
}

/*
 *
 */

NTSTATUS 
xfs_devctl (PDEVICE_OBJECT device, PIRP irp)
{ 

    xfs_log (device,
	     IoGetCurrentIrpStackLocation(irp)->MajorFunction,
	     0,
	     0,
	     STATUS_NO_MEDIA_IN_DEVICE,
	     2,
	     xfs_log_new_seq(),
	     0,
	     0,
	     NULL,
	     0,
	     NULL);


    irp->IoStatus.Status = STATUS_NO_MEDIA_IN_DEVICE;
    irp->IoStatus.Information = 0;
    IoCompleteRequest(irp, IO_NO_INCREMENT);
    
    return STATUS_NO_MEDIA_IN_DEVICE;
}

/*
 *
 */

NTSTATUS 
xfs_shutdown (PDEVICE_OBJECT device, PIRP irp)
{
    irp->IoStatus.Status = STATUS_SUCCESS;
    irp->IoStatus.Information = 0;
    IoCompleteRequest(irp, IO_NO_INCREMENT);
     
    return STATUS_SUCCESS;
}

/*
 *
 */

NTSTATUS 
xfs_cleanup (PDEVICE_OBJECT device, PIRP irp)
{
    irp->IoStatus.Status = STATUS_SUCCESS;
    irp->IoStatus.Information = 0;
    IoCompleteRequest(irp, IO_NO_INCREMENT);
     
    return STATUS_SUCCESS;
}




