/*
 * Copyright (c) 1999 Kungliga Tekniska Hgskolan
 * (Royal Institute of Technology, Stockholm, Sweden).
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *      This product includes software developed by the Kungliga Tekniska
 *      Hgskolan and its contributors.
 * 
 * 4. Neither the name of the Institute nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE INSTITUTE AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE INSTITUTE OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

/* $Id: xfs_deb.c,v 1.1 1999/07/12 11:25:55 lha Exp $ */

#include <xfs_locl.h>

LONG xfsdeb_SequenceNumber = 0;

LONG
xfs_log_new_seq (void)
{
    return xfsdeb_SequenceNumber++;
}


void
xfs_log (PDEVICE_OBJECT dev,
	 UCHAR MajorFunctionCode,
	 UCHAR RetryCount,
	 USHORT EventCategory,
	 NTSTATUS ErrorCode,
	 ULONG UniqueErrorValue,
	 LONG SequenceNumber,
	 ULONG IoControlCode,
	 USHORT DataDumpSize,
	 ULONG DumpData[],
	 USHORT NumStrings,
	 CHAR *Strings[])
{
    PIO_ERROR_LOG_PACKET pkt;
    UCHAR size = sizeof (IO_ERROR_LOG_PACKET);
    int i;

    size += DataDumpSize * sizeof(ULONG);
    
    ASSERT (StringsSize == 0);
    /* XXX Add strings to size */

    pkt = IoAllocateErrorLogEntry (dev, size);

    if (pkt == NULL)
	return;
    
    pkt->MajorFunctionCode	= MajorFunctionCode;
    pkt->RetryCount		= RetryCount;
    pkt->DumpDataSize		= DataDumpSize;
    pkt->NumberOfStrings	= NumStrings;
    pkt->StringOffset		= 0;
    pkt->EventCategory		= EventCategory;
    pkt->ErrorCode		= ErrorCode;
    pkt->UniqueErrorValue	= UniqueErrorValue;
    pkt->SequenceNumber	        = SequenceNumber;
    pkt->IoControlCode		= IoControlCode;
    pkt->DeviceOffset.LowPart	= 0;
    pkt->DeviceOffset.HighPart	= 0;
    for (i = 0; i < DataDumpSize; i++)
	pkt->DumpData[i]	= DumpData[i];
    
    /* XXX fill in strings here */

    IoWriteErrorLogEntry (pkt);
}


