/*
 * Copyright (c) 1999 Kungliga Tekniska Hgskolan
 * (Royal Institute of Technology, Stockholm, Sweden).
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *      This product includes software developed by the Kungliga Tekniska
 *      Hgskolan and its contributors.
 * 
 * 4. Neither the name of the Institute nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE INSTITUTE AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE INSTITUTE OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */


#define DEFINE_IRP(x) NTSTATUS x (PDEVICE_OBJECT device, PIRP irp)

DEFINE_IRP(xfs_create);
DEFINE_IRP(xfs_close);
DEFINE_IRP(xfs_read);
DEFINE_IRP(xfs_write);
DEFINE_IRP(xfs_fileinfo);
DEFINE_IRP(xfs_flush);
DEFINE_IRP(xfs_dirctl);
DEFINE_IRP(xfs_devctl);
DEFINE_IRP(xfs_shutdown);
DEFINE_IRP(xfs_cleanup);

#undef DEFINE_IRP

LONG
xfs_log_new_seq (void);

void
xfs_log (PDEVICE_OBJECT dev,
	 UCHAR MajorFunctionCode,
	 UCHAR RetryCount,
	 USHORT EventCategory,
	 NTSTATUS ErrorCode,
	 ULONG UniqueErrorValue,
	 LONG SequenceNumber,
	 ULONG IoControlCode,
	 USHORT DumpDataSize,
	 ULONG DumpData[],
	 USHORT NumStrings,
	 CHAR *Strings[]);

