/*
 * Copyright (c) 1999 Kungliga Tekniska Hgskolan
 * (Royal Institute of Technology, Stockholm, Sweden).
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *      This product includes software developed by the Kungliga Tekniska
 *      Hgskolan and its contributors.
 * 
 * 4. Neither the name of the Institute nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE INSTITUTE AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE INSTITUTE OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ifndef _XFS_XFS_LOCL_H
#define _XFS_XFS_LOCL_H

#include <ntifs.h>

#include <xfs_type.h>
#include <xfs_proto.h>

/* try-finally simulation */
#define try_return(S)	{ S; goto try_exit; }
#define try_return1(S)	{ S; goto try_exit1; }
#define try_return2(S)	{ S; goto try_exit2; }


#define XFS_DEV_DATA_MAGIC	0x4711C00E

#define XFS_SETFLAGS(v,f) ((v) |= (f))
#define XFS_TESTFLAGS(v,f) (((v) & (f)) == (f))

#define DEVDATA_FLAGS_GLOBALLOCK 0x1

typedef struct _XFSDevData {
    int32_t		magic;		/* magic */
    ERESOURCE		GlobalLock;	/* global lock */
    PDRIVER_OBJECT	DriverObject;	/* created by I/O mgr*/
    PDEVICE_OBJECT	DeviceObject;	/* to be able to do IOCTL*/
    LIST_ENTRY		NextVCB;	/* all logical volumes */
    CACHE_MANAGER_CALLBACKS CacheMgrCallBacks; /* for callbacks from cachemgr */
    HANDLE		MupHandle;	/* handle from mup */

    u_int32_t		flags;		/* varius flags */
#if 0
    Not yet;
    
    // the NT Cache Manager, the I/O Manager and we will conspire
    //	to bypass IRP usage using the function pointers contained
    //	in the following structure
    FAST_IO_DISPATCH			SFsdFastIoDispatch;

    // currently, there is a single default zone size value used for
    //	all zones. This should ideally be changed by you to be 1 per
    //	type of zone (e.g. a default size for the FCB zone might be
    //	different from the default size for the ByteLock zone).
    // structures allocated from a zone need some fields here. Note
    //	that under version 4.0, it might be better to use lookaside
    //	lists
    KSPIN_LOCK					ZoneAllocationSpinLock;
    ZONE_HEADER					ObjectNameZoneHeader;
    ZONE_HEADER					CCBZoneHeader;
    ZONE_HEADER					FCBZoneHeader;
    ZONE_HEADER					ByteLockZoneHeader;
    ZONE_HEADER					IrpContextZoneHeader;
    void							*ObjectNameZone;
    void							*CCBZone;
    void							*FCBZone;
    void							*ByteLockZone;
    void							*IrpContextZone;

    //	Of course, you will need to use different values (min/max)
    //	for lookaside lists (if you decide to use them instead)
    uint32						DefaultZoneSizeInNumStructs;
    // some state information is maintained in the flags field
    uint32						SFsdFlags;

#endif

} XFSDevData;

extern XFSDevData XFSGlobalData;	/* global data for xfs driver */

#endif
