/*
 * Copyright (c) 1995, 1996, 1997, 1998, 1999 Kungliga Tekniska Hgskolan
 * (Royal Institute of Technology, Stockholm, Sweden).
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *      This product includes software developed by the Kungliga Tekniska
 *      Hgskolan and its contributors.
 * 
 * 4. Neither the name of the Institute nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE INSTITUTE AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE INSTITUTE OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

/* $Id: xfs_locl.h,v 1.31.2.1 1999/08/27 11:36:07 lha Exp $ */
/* $Source: /afs/stacken.kth.se/src/SourceRepository/arla/xfs/linux/xfs/xfs_locl.h,v $ */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#ifdef HAVE_ASM_CURRENT_H
#include <asm/current.h>
#endif
#include <linux/config.h>
#ifdef CONFIG_MODVERSIONS
#define MODVERSIONS
#ifdef HAVE_LINUX_MODVERSIONS_H
#include <linux/modversions.h>
#endif
#endif
#include <linux/version.h>
#include <linux/module.h>
#include <linux/errno.h>
#include <linux/fs.h>
#include <linux/malloc.h>
#include <linux/sched.h>
#include <linux/stat.h>
#include <linux/string.h>
#include <linux/locks.h>
#ifdef HAVE_LINUX_DEVFS_FS_H
#include <linux/devfs_fs.h>
#ifdef CONFIG_DEVFS_FS
#define DEVFS_SUPPORT
#endif
#endif

#if LINUX_VERSION_CODE > 131238
#define LINUX2_1 1
#endif

#ifdef LINUX2_1
#include <asm/uaccess.h>
#else
#include <asm/segment.h>
#endif

/* 
 * The people at FSF seems to think that user program
 * should include /usr/include/{,sys} and the kernel
 * should have their own include files.
 *
 * That seems ok to me, but then we don't get the int23_t & friends
 * from userland. And in kernelspace it seems that we should use 
 * __{s,u}32, and that seems silly, so we typedef them ourself.
 * It's the same thing with MAXPATHLEN that is named PATH_MAX in 
 * the kernel.
 *
 * Thank you to N.N for pointing this out.
 */

#ifdef HAVE_GLIBC

#ifndef HAVE_LINUX_KERNEL_INT8_T
typedef __s8     int8_t;
#endif
#ifndef HAVE_LINUX_KERNEL_U_INT8_T
typedef __u8   u_int8_t;
#endif
#ifndef HAVE_LINUX_KERNEL_INT16_T
typedef __s16    int16_t;
#endif
#ifndef HAVE_LINUX_KERNEL_U_INT16_T
typedef __u16  u_int16_t;
#endif
#ifndef HAVE_LINUX_KERNEL_INT32_T
typedef __s32    int32_t;
#endif
#ifndef HAVE_LINUX_KERNEL_U_INT32_T
typedef __u32  u_int32_t;
#endif

#ifndef MAXPATHLEN
#define MAXPATHLEN PATH_MAX 
#endif

#endif

#include <xfs/xfs_message.h>
#include <xfs/xfs_fs.h>
#include <xfs/xfs_node.h>
#include <xfs/xfs_deb.h>

int
#ifndef LINUX2_1
xfs_root(struct super_block *sb, struct inode **vpp);
#else
xfs_root(struct super_block *sb, struct dentry **dp);
#endif /* LINUX2_1 */


#ifndef LINUX2_1
extern inline int signal_pending(struct task_struct *p)
{
        return (p->signal &~ p->blocked) != 0;
}
#endif /* LINUX2_1 */

#ifdef LINUX2_1
extern struct dentry_operations xfs_dentry_operations;

struct dentry * xfs_fh_to_dentry(struct xfs_cache_handle *handle);
#endif

#ifdef LINUX2_1

#if HAVE_FULL_NAME_HASH_8BIT

static __inline__ unsigned int
xfs_full_name_hash(const unsigned char * name, unsigned int len)
{
    return full_name_hash (name, len);
}

#else

/* this macro is broken in linux 2.1.131, see dcache.h */

static __inline__ unsigned int
xfs_full_name_hash(const unsigned char * name, unsigned int len)
{
  unsigned long hash = init_name_hash();
  while (len--)
    hash = partial_name_hash(*name++, hash);
  return end_name_hash(hash);
}

#endif

#endif

/*
 * i_blocks should apparently always be returned in 512-bytes units
 */

#define I_BLOCKS_UNIT 512
