/*
 * Copyright (c) 1995, 1996, 1997, 1998 Kungliga Tekniska Hgskolan
 * (Royal Institute of Technology, Stockholm, Sweden).
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *      This product includes software developed by the Kungliga Tekniska
 *      Hgskolan and its contributors.
 * 
 * 4. Neither the name of the Institute nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE INSTITUTE AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE INSTITUTE OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

/* $Id: xfs_common.h,v 1.17 1999/01/10 18:48:01 map Exp $ */
/* $Source: /afs/stacken.kth.se/src/SourceRepository/arla/xfs/linux/xfs/xfs_common.h,v $ */

#ifndef _xfs_common_h
#define _xfs_common_h

#define XFS_MEM_NONE 0
#define XFS_MEM_XFSCACHE 1
#define XFS_MEM_MSGBUF 2
#define XFS_MEM_SENDRPC 3
#define XFS_MEM_DENTRY 4
#define XFS_MEM_READDIR 5
#define XFS_MEM_FOLLOWLINK 6
#define XFS_MEM_XNODE 7

void *xfs_alloc (u_int size, int service);
void xfs_free (void *, int service);
void xfs_tell_alloc(void);
void xfs_print_sleep_queue(void);

extern struct inode_operations xfs_file_inode_operations,
                               xfs_dir_inode_operations,
                               xfs_link_inode_operations,
                               xfs_dead_inode_operations;

#ifdef LINUX2_1
struct xfs_dentry_data {
    int valid;
    int requested;
    struct semaphore sem;
};

#define DENTRY_TO_XDENTRY(d) ((struct xfs_dentry_data *)((d)->d_fsdata))

void
xfs_d_init (struct dentry *dentry);
#endif

#ifdef LINUX2_1
#define DENTRY dentry
#define DENTRY_TO_INODE(x) ((x)->d_inode)
#define DPUT(x) dput(x)
#else
#define DENTRY inode
#define DENTRY_TO_INODE(x) (x)
#define DPUT(x) iput(x)
int init_private_file(struct file *filp, struct inode *inode, int mode);
#endif

#ifndef LINUX2_1
static inline unsigned long
copy_to_user(void *dst, const void *src, unsigned long len)
{
    if (verify_area(VERIFY_WRITE, dst, len) != 0)
	return len;
    memcpy_tofs(dst, src, len);
    return 0;
}

static inline unsigned long
copy_from_user(void *dst, const void *src, unsigned long len)
{
    if (verify_area(VERIFY_READ, src, len) != 0)
	return len;
    memcpy_fromfs(dst, src, len);
    return 0;
}
#endif

#ifdef LINUX2_1
void print_aliases(struct inode *inode);
void print_childs(struct dentry *dentry);
#endif

#endif /* _xfs_common_h */
