/*
 * Copyright (c) 1999 Kungliga Tekniska Hgskolan
 * (Royal Institute of Technology, Stockholm, Sweden).
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *      This product includes software developed by the Kungliga Tekniska
 *      Hgskolan and its contributors.
 * 
 * 4. Neither the name of the Institute nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE INSTITUTE AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE INSTITUTE OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

/* $Id: voldb.h,v 1.3 1999/06/23 09:27:49 lha Exp $ */

#ifndef FILBUNKE_VOLDB_H
#define FILBUNKE_VOLDB_H 1

#include <volumeserver.h>
#include <fs_def.h>

/*
 * Data structure for a file (link is same)
 */

struct voldb_file_entry {    
    u_int32_t nextptr;
    u_int32_t unique;
    u_int32_t ino;
    u_int32_t spare2;		/* Must be zero */
    u_int32_t InterfaceVersion;
    u_int32_t FileType;
    u_int32_t LinkCount;
    u_int32_t Length;
    u_int32_t spare3;		/* Must be zero */
    u_int32_t DataVersion;
    u_int32_t Author;
    u_int32_t Owner;
    u_int32_t UnixModeBits;
    u_int32_t ParentVnode;
    u_int32_t ParentUnique;
    u_int32_t SegSize;
    u_int32_t ServerModTime;
    u_int32_t spare4;		/* Must be zero */
    u_int32_t Group;
    u_int32_t spare5;		/* Must be zero */
};

/*
 * Data structure for a dir
 */

struct voldb_dir_entry {    
    u_int32_t nextptr;
    u_int32_t unique;
    u_int32_t ino;
    u_int32_t spare2;		/* Must be zero */
    u_int32_t InterfaceVersion;
    u_int32_t FileType;
    u_int32_t LinkCount;
    u_int32_t Length;
    u_int32_t spare3;		/* Must be zero */
    u_int32_t DataVersion;
    u_int32_t Author;
    u_int32_t Owner;
    u_int32_t UnixModeBits;
    u_int32_t ParentVnode;
    u_int32_t ParentUnique;
    u_int32_t SegSize;
    u_int32_t ServerModTime;
    u_int32_t spare4;		/* Must be zero */
    u_int32_t Group;
    u_int32_t spare5;		/* Must be zero */
    struct {
	u_int32_t owner;
	u_int32_t flags;
    } acl[FS_MAX_ACL];
};

/* defines */

#define VOLDB_FILE 0x1
#define VOLDB_DIR 0x2

/* forward declarations */

struct voldb;

/* prototypes */

int
voldb_init (int fd, struct voldb **db);

int
voldb_close (struct voldb *db);

int
voldb_get_dir (struct voldb *db, u_int32_t num, struct voldb_dir_entry *e);

int
voldb_put_dir (struct voldb *db, u_int32_t num, struct voldb_dir_entry *e);

int
voldb_put_acl (struct voldb *db, u_int32_t num, struct voldb_dir_entry *e);

int
voldb_get_file (struct voldb *db, u_int32_t num, struct voldb_file_entry *e);

int
voldb_put_file (struct voldb *db, u_int32_t num, struct voldb_file_entry *e);

int
voldb_pretty_print_file (struct voldb_file_entry *e);

int
voldb_pretty_print_dir (struct voldb_dir_entry *e);

int
voldb_create_header (int fd, int flags);

int
voldb_flush (struct voldb *db);

int
voldb_extend_db (struct voldb *db, unsigned int num);

int
voldb_new_entry (struct voldb *db, u_int32_t *num, u_int32_t *unique);

int
voldb_del_entry (struct voldb *db, u_int32_t num, int32_t *ino);

int
voldb_header_info (struct voldb *db, u_int32_t *num,
		   u_int32_t *freeptr, u_int32_t *flags);

/* vol.c */

int
vol_getname (u_int32_t num, char *str, size_t sz);

int
vol_getfullname (u_int32_t part, u_int32_t num, char *str, size_t sz);

int
vol_read_header (int fd, volintInfo *info);

int
vol_write_header (int fd, volintInfo *info);

int
vol_create (int fd, u_int32_t num, const char *name,
	    u_int32_t type, u_int32_t parent);

void
vol_pretty_print_info (FILE *out, volintInfo *info);

#define VOLDB_ENTEND_NUM 10

const char *
vol_voltype2name (int32_t type);

#endif /*  FILBUNKE_VOLDB_H 1 */
