/*
 * Copyright (c) 1999 Kungliga Tekniska Hgskolan
 * (Royal Institute of Technology, Stockholm, Sweden).
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *      This product includes software developed by the Kungliga Tekniska
 *      Hgskolan and its contributors.
 * 
 * 4. Neither the name of the Institute nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE INSTITUTE AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE INSTITUTE OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

/* $Id: vld.h,v 1.6 1999/07/18 19:51:13 map Exp $ */

#include <dpart.h>
#include <voldb.h>

#include <fs.h>
#include <volumeserver.h>

#include <fbuf.h>
#include <list.h>

/*
 * Type of volumes
 */

#define VLD_SVOL 0

/*
 * structures
 */

typedef struct volume_handle {
    int type;			/* type of volume */
    u_int32_t vol;		/* volume number */
    int ref;			/* refcount */
    struct dp_part *dp;		/* on what partition the volume resides */
    void *data;			/* data blob for volume type */
    volintInfo info;		/* info struct */
    struct {
	long infop:1 ;		/* if there is valid info in node */
	long voldbp:1 ;		/* if voldb has been read in */
	long offlinep:1;	/* if volume is offline */
    } flags ;
    ino_t sino;			/* inode number of volume entry  */
    ino_t dino;			/* inode number of db of dirs */
    ino_t fino;			/* inode number of db of files */
    struct voldb *db[2];	/* large and small vnode tables */
    Listitem *db_li;		/* position in db_lru */
} volume_handle;

typedef struct volume_operations {
    char *name;
    int  (*open)(struct dp_part *part, int32_t volid, 
		 int flags, void **vol);
#define VOLOP_NOFLAGS 0x0
#define VOLOP_CREATE 0x1
    void (*free)(volume_handle *vol);
    int  (*icreate)(volume_handle *vol, ino_t *ino);
    int  (*iopen)(volume_handle *vol, ino_t ino, int flags, int *fd);
    int  (*iunlink)(volume_handle *vol, ino_t ino); 
    int  (*remove)(volume_handle *vol);
} vol_op;

int
vld_boot (void);

int
vld_init (void);

void
vld_free (volume_handle *vol);

void
vld_ref (volume_handle *vol);

int
vld_register_backstore_type (const int32_t backstoretype, vol_op *ops);

int
vld_find_vol (const int32_t volid, struct volume_handle **vld);

int
vld_create_volume (struct dp_part *dp, int32_t volid, 
		   char *name, int32_t backstoretype);

const char *
vld_backstoretype_name (int32_t backstoretype);

int
vld_vld2volsync (const struct volume_handle *vld, AFSVolSync *volsync);

int
vld_open_volume_by_num (struct dp_part *dp, int32_t volid,
			volume_handle **vol);

int
vld_open_volume_by_fd (struct dp_part *dp, int fd,
		       volume_handle **vol);

int
vld_open_inode (volume_handle *vol, ino_t ino, int flags, int *fd);

int
vld_info_uptodatep (volume_handle *vol);

int
vld_db_uptodate (volume_handle *vol);

int
vld_open_vnode (volume_handle *vol, int32_t vno, AFSFetchStatus *fs, 
		int flags, int *rfd, prlist *cps);

int
vld_update_size_fd (AFSFetchStatus *fs, int fd);

int
vld_update_size_fbuf (AFSFetchStatus *fs, fbuf *the_fbuf);

int
vld_modify_vnode (volume_handle *vol, int32_t vno, const AFSStoreStatus *ss,
		  AFSFetchStatus *fs, int flags, int *rfd, prlist *cps);

int
vld_create_directory (volume_handle *vol, const AFSFid *parent, AFSFid *child,
		      const AFSStoreStatus *ss, prlist *cps);

int
vld_adjust_linkcount (volume_handle *vol, int32_t vno, int adjust);

int
vld_create_file (volume_handle *vol, const AFSFid *parent, AFSFid *child,
		 int32_t type, const AFSStoreStatus *ss, prlist *cps);

int
vld_remove_node (volume_handle *vol, int32_t node);

int
vld_db_flush (volume_handle *vol);

void
vld_end (void);

